/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQuerySummary;
import software.amazon.awssdk.services.cloudwatchlogs.model.ScheduledQuerySummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScheduledQueriesResponse
extends CloudWatchLogsResponse
implements ToCopyableBuilder<Builder, ListScheduledQueriesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListScheduledQueriesResponse.getter(ListScheduledQueriesResponse::nextToken)).setter(ListScheduledQueriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ScheduledQuerySummary>> SCHEDULED_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("scheduledQueries").getter(ListScheduledQueriesResponse.getter(ListScheduledQueriesResponse::scheduledQueries)).setter(ListScheduledQueriesResponse.setter(Builder::scheduledQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scheduledQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScheduledQuerySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCHEDULED_QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListScheduledQueriesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ScheduledQuerySummary> scheduledQueries;

    private ListScheduledQueriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.scheduledQueries = builder.scheduledQueries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasScheduledQueries() {
        return this.scheduledQueries != null && !(this.scheduledQueries instanceof SdkAutoConstructList);
    }

    public final List<ScheduledQuerySummary> scheduledQueries() {
        return this.scheduledQueries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduledQueries() ? this.scheduledQueries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScheduledQueriesResponse)) {
            return false;
        }
        ListScheduledQueriesResponse other = (ListScheduledQueriesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasScheduledQueries() == other.hasScheduledQueries() && Objects.equals(this.scheduledQueries(), other.scheduledQueries());
    }

    public final String toString() {
        return ToString.builder((String)"ListScheduledQueriesResponse").add("NextToken", (Object)this.nextToken()).add("ScheduledQueries", this.hasScheduledQueries() ? this.scheduledQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "scheduledQueries": {
                return Optional.ofNullable(clazz.cast(this.scheduledQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("scheduledQueries", SCHEDULED_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScheduledQueriesResponse, T> g) {
        return obj -> g.apply((ListScheduledQueriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ScheduledQuerySummary> scheduledQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScheduledQueriesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.scheduledQueries(model.scheduledQueries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ScheduledQuerySummary.Builder> getScheduledQueries() {
            List<ScheduledQuerySummary.Builder> result = ScheduledQuerySummaryListCopier.copyToBuilder(this.scheduledQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduledQueries(Collection<ScheduledQuerySummary.BuilderImpl> scheduledQueries) {
            this.scheduledQueries = ScheduledQuerySummaryListCopier.copyFromBuilder(scheduledQueries);
        }

        @Override
        public final Builder scheduledQueries(Collection<ScheduledQuerySummary> scheduledQueries) {
            this.scheduledQueries = ScheduledQuerySummaryListCopier.copy(scheduledQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledQueries(ScheduledQuerySummary ... scheduledQueries) {
            this.scheduledQueries(Arrays.asList(scheduledQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledQueries(Consumer<ScheduledQuerySummary.Builder> ... scheduledQueries) {
            this.scheduledQueries(Stream.of(scheduledQueries).map(c -> (ScheduledQuerySummary)((ScheduledQuerySummary.Builder)ScheduledQuerySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScheduledQueriesResponse build() {
            return new ListScheduledQueriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudWatchLogsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScheduledQueriesResponse> {
        public Builder nextToken(String var1);

        public Builder scheduledQueries(Collection<ScheduledQuerySummary> var1);

        public Builder scheduledQueries(ScheduledQuerySummary ... var1);

        public Builder scheduledQueries(Consumer<ScheduledQuerySummary.Builder> ... var1);
    }
}

