/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.pekko.persistence.jdbc.integration

import com.typesafe.config.ConfigFactory
import org.apache.pekko.persistence.jdbc.state.scaladsl.{
  DurableStateStorePluginSpec, DurableStateStoreSchemaPluginSpec
}
import slick.jdbc.MySQLProfile

class MySQLDurableStateStorePluginSpec
    extends DurableStateStorePluginSpec(ConfigFactory.load("mysql-application.conf"), MySQLProfile) {}

class MySQLDurableStateStorePluginSharedSpec
    extends DurableStateStorePluginSpec(ConfigFactory.load("mysql-shared-db-application.conf"), MySQLProfile) {}

class MySQLDurableStateStorePluginExplicitSelectSpec
    extends DurableStateStorePluginSpec(ConfigFactory.load("mysql-explicit-select-application.conf"), MySQLProfile) {}

class MySQLDurableStateStorePluginSharedExplicitSelectSpec
    extends DurableStateStorePluginSpec(ConfigFactory.load("mysql-shared-db-explicit-select-application.conf"),
      MySQLProfile) {}

class MySQLDurableStateStorePluginSchemaSpec
    extends DurableStateStoreSchemaPluginSpec(ConfigFactory.load("mysql-application.conf"),
      MySQLProfile) {}

class MySQLDurableStateStorePluginSchemaExplicitSelectSpec
    extends DurableStateStoreSchemaPluginSpec(ConfigFactory.load("mysql-explicit-select-application.conf"),
      MySQLProfile) {}
