/*
 * Decompiled with CFR 0.152.
 */
package org.archive.extract;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.archive.extract.ExtractorOutput;
import org.archive.format.json.JSONView;
import org.archive.resource.Resource;
import org.archive.util.StreamCopy;

public class JSONViewExtractorOutput
implements ExtractorOutput {
    private PrintStream out;
    private JSONView view;

    public JSONViewExtractorOutput(OutputStream out, String filterPath) {
        this.view = new JSONView(filterPath.split(","));
        try {
            this.out = new PrintStream(out, false, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    public void output(Resource resource) throws IOException {
        StreamCopy.readToEOF(resource.getInputStream());
        List<List<String>> data = this.view.apply(resource.getMetaData().getTopMetaData());
        if (data != null) {
            for (List<String> d : data) {
                this.out.println(StringUtils.join(d, (String)"\t"));
            }
        }
    }
}

