/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.crawl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.crawl.Inlink;

public class Inlinks
implements Writable {
    private HashSet<Inlink> inlinks = new HashSet(1);

    public void add(Inlink inlink) {
        this.inlinks.add(inlink);
    }

    public void add(Inlinks inlinks) {
        this.inlinks.addAll(inlinks.inlinks);
    }

    public Iterator<Inlink> iterator() {
        return this.inlinks.iterator();
    }

    public int size() {
        return this.inlinks.size();
    }

    public void clear() {
        this.inlinks.clear();
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        this.inlinks.clear();
        for (int i = 0; i < length; ++i) {
            this.add(Inlink.read(in));
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.inlinks.size());
        Iterator<Inlink> it = this.inlinks.iterator();
        while (it.hasNext()) {
            it.next().write(out);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Inlinks:\n");
        Iterator<Inlink> it = this.inlinks.iterator();
        while (it.hasNext()) {
            buffer.append(" ");
            buffer.append(it.next());
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public String[] getAnchors() {
        HashMap<String, HashSet<String>> domainToAnchors = new HashMap<String, HashSet<String>>();
        ArrayList<String> results = new ArrayList<String>();
        for (Inlink inlink : this.inlinks) {
            String anchor = inlink.getAnchor();
            if (anchor.length() == 0) continue;
            String domain = null;
            try {
                domain = new URL(inlink.getFromUrl()).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            HashSet<String> domainAnchors = (HashSet<String>)domainToAnchors.get(domain);
            if (domainAnchors == null) {
                domainAnchors = new HashSet<String>();
                domainToAnchors.put(domain, domainAnchors);
            }
            if (!domainAnchors.add(anchor)) continue;
            results.add(anchor);
        }
        return results.toArray(new String[results.size()]);
    }
}

