/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Version;

public final class LeafMetaData {
    private final int createdVersionMajor;
    private final Version minVersion;
    private final Sort sort;

    public LeafMetaData(int createdVersionMajor, Version minVersion, Sort sort) {
        this.createdVersionMajor = createdVersionMajor;
        if (createdVersionMajor > Version.LATEST.major) {
            throw new IllegalArgumentException("createdVersionMajor is in the future: " + createdVersionMajor);
        }
        if (createdVersionMajor < 6) {
            throw new IllegalArgumentException("createdVersionMajor must be >= 6, got: " + createdVersionMajor);
        }
        if (minVersion != null && !minVersion.onOrAfter(Version.LUCENE_7_0_0)) {
            throw new IllegalArgumentException("minVersion must be >= 7.0.0: " + minVersion);
        }
        if (createdVersionMajor >= 7 && minVersion == null) {
            throw new IllegalArgumentException("minVersion must be set when createdVersionMajor is >= 7");
        }
        this.minVersion = minVersion;
        this.sort = sort;
    }

    public int getCreatedVersionMajor() {
        return this.createdVersionMajor;
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public Sort getSort() {
        return this.sort;
    }
}

