/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.jackson;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.core.log.LogMessage;
import org.springframework.security.jackson.SecurityJacksonModule;
import org.springframework.util.ClassUtils;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.module.SimpleModule;

public final class SecurityJacksonModules {
    private static final Log logger = LogFactory.getLog(SecurityJacksonModules.class);
    private static final List<String> securityJacksonModuleClasses = Arrays.asList("org.springframework.security.jackson.CoreJacksonModule", "org.springframework.security.web.jackson.WebJacksonModule", "org.springframework.security.web.server.jackson.WebServerJacksonModule");
    private static final String webServletJacksonModuleClass = "org.springframework.security.web.jackson.WebServletJacksonModule";
    private static final String oauth2ClientJacksonModuleClass = "org.springframework.security.oauth2.client.jackson.OAuth2ClientJacksonModule";
    private static final String oauth2AuthorizationServerJacksonModuleClass = "org.springframework.security.oauth2.server.authorization.jackson.OAuth2AuthorizationServerJacksonModule";
    private static final String ldapJacksonModuleClass = "org.springframework.security.ldap.jackson.LdapJacksonModule";
    private static final String saml2JacksonModuleClass = "org.springframework.security.saml2.jackson.Saml2JacksonModule";
    private static final String casJacksonModuleClass = "org.springframework.security.cas.jackson.CasJacksonModule";
    private static final boolean webServletPresent;
    private static final boolean oauth2ClientPresent;
    private static final boolean oauth2AuthorizationServerPresent;
    private static final boolean ldapJacksonPresent;
    private static final boolean saml2JacksonPresent;
    private static final boolean casJacksonPresent;

    private SecurityJacksonModules() {
    }

    private static @Nullable SecurityJacksonModule loadAndGetInstance(String className, ClassLoader loader) {
        try {
            Class securityModule = ClassUtils.forName((String)className, (ClassLoader)loader);
            logger.debug((Object)LogMessage.format((String)"Loaded module %s, now registering", (Object)className));
            return (SecurityJacksonModule)((Object)securityModule.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            logger.debug((Object)LogMessage.format((String)"Cannot load module %s", (Object)className), (Throwable)ex);
            return null;
        }
    }

    public static List<JacksonModule> getModules(ClassLoader loader) {
        return SecurityJacksonModules.getModules(loader, null);
    }

    public static List<JacksonModule> getModules(ClassLoader loader, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable BasicPolymorphicTypeValidator.Builder typeValidatorBuilder) {
        ArrayList<JacksonModule> modules = new ArrayList<JacksonModule>();
        for (String className : securityJacksonModuleClasses) {
            SecurityJacksonModules.addToModulesList(loader, modules, className);
        }
        if (webServletPresent) {
            SecurityJacksonModules.addToModulesList(loader, modules, webServletJacksonModuleClass);
        }
        if (oauth2ClientPresent) {
            SecurityJacksonModules.addToModulesList(loader, modules, oauth2ClientJacksonModuleClass);
        }
        if (oauth2AuthorizationServerPresent) {
            SecurityJacksonModules.addToModulesList(loader, modules, oauth2AuthorizationServerJacksonModuleClass);
        }
        if (ldapJacksonPresent) {
            SecurityJacksonModules.addToModulesList(loader, modules, ldapJacksonModuleClass);
        }
        if (saml2JacksonPresent) {
            SecurityJacksonModules.addToModulesList(loader, modules, saml2JacksonModuleClass);
        }
        if (casJacksonPresent) {
            SecurityJacksonModules.addToModulesList(loader, modules, casJacksonModuleClass);
        }
        SecurityJacksonModules.applyPolymorphicTypeValidator(modules, typeValidatorBuilder);
        return modules;
    }

    private static void applyPolymorphicTypeValidator(List<JacksonModule> modules, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable BasicPolymorphicTypeValidator.Builder typeValidatorBuilder) {
        final BasicPolymorphicTypeValidator.Builder builder = typeValidatorBuilder != null ? typeValidatorBuilder : BasicPolymorphicTypeValidator.builder();
        for (JacksonModule module : modules) {
            if (!(module instanceof SecurityJacksonModule)) continue;
            SecurityJacksonModule securityModule = (SecurityJacksonModule)module;
            securityModule.configurePolymorphicTypeValidator(builder);
        }
        modules.add((JacksonModule)new SimpleModule(){

            public void setupModule(JacksonModule.SetupContext context) {
                ((MapperBuilder)context.getOwner()).activateDefaultTyping((PolymorphicTypeValidator)builder.build(), DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY);
            }
        });
    }

    private static void addToModulesList(ClassLoader loader, List<JacksonModule> modules, String className) {
        SecurityJacksonModule module = SecurityJacksonModules.loadAndGetInstance(className, loader);
        if (module != null) {
            modules.add((JacksonModule)module);
        }
    }

    static {
        ClassLoader classLoader = SecurityJacksonModules.class.getClassLoader();
        webServletPresent = ClassUtils.isPresent((String)"jakarta.servlet.http.Cookie", (ClassLoader)classLoader);
        oauth2ClientPresent = ClassUtils.isPresent((String)"org.springframework.security.oauth2.client.OAuth2AuthorizedClient", (ClassLoader)classLoader);
        oauth2AuthorizationServerPresent = ClassUtils.isPresent((String)"org.springframework.security.oauth2.server.authorization.OAuth2Authorization", (ClassLoader)classLoader);
        ldapJacksonPresent = ClassUtils.isPresent((String)ldapJacksonModuleClass, (ClassLoader)classLoader);
        saml2JacksonPresent = ClassUtils.isPresent((String)saml2JacksonModuleClass, (ClassLoader)classLoader);
        casJacksonPresent = ClassUtils.isPresent((String)casJacksonModuleClass, (ClassLoader)classLoader);
    }
}

