/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import jpt.sun.tools.javac.util.InvalidUtfException;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.Name;

public class Convert {
    public static int string2int(String s, int radix) throws NumberFormatException {
        if (radix == 10) {
            return Integer.parseInt(s, radix);
        }
        char[] cs = s.toCharArray();
        int limit = Integer.MAX_VALUE / (radix / 2);
        int n = 0;
        for (char c : cs) {
            int d = Character.digit(c, radix);
            if (n < 0 || n > limit || n * radix > Integer.MAX_VALUE - d) {
                throw new NumberFormatException();
            }
            n = n * radix + d;
        }
        return n;
    }

    public static long string2long(String s, int radix) throws NumberFormatException {
        if (radix == 10) {
            return Long.parseLong(s, radix);
        }
        char[] cs = s.toCharArray();
        long limit = Long.MAX_VALUE / (long)(radix / 2);
        long n = 0L;
        for (char c : cs) {
            int d = Character.digit(c, radix);
            if (n < 0L || n > limit || n * (long)radix > Long.MAX_VALUE - (long)d) {
                throw new NumberFormatException();
            }
            n = n * (long)radix + (long)d;
        }
        return n;
    }

    public static void utfValidate(byte[] buf, int off, int len, Validation validation) throws InvalidUtfException {
        Convert.utf2chars(buf, off, null, 0, len, validation);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int utf2chars(byte[] src, int soff, char[] dst, int doff, int len, Validation validation) throws InvalidUtfException {
        int doff0 = doff;
        while (len-- > 0) {
            int value;
            int soff0 = soff;
            if ((value = src[soff++]) < 0) {
                byte value2;
                if ((value & 0xE0) == 192) {
                    if (len-- > 0) {
                        value2 = src[soff++];
                    } else {
                        if (!validation.allowAnything()) throw new InvalidUtfException(soff0);
                        value2 = 0;
                    }
                    if (!validation.allowAnything() && (value2 & 0xC0) != 128) {
                        throw new InvalidUtfException(soff0);
                    }
                    value = (value & 0x1F) << 6 | value2 & 0x3F;
                    if (!validation.allowLongEncoding() && (value & 0xFFFFFF80) == 0 && value != 0) {
                        throw new InvalidUtfException(soff0);
                    }
                } else if ((value & 0xF0) == 224) {
                    byte value3;
                    if ((len -= 2) >= 0) {
                        value2 = src[soff++];
                        value3 = src[soff++];
                    } else {
                        if (!validation.allowAnything()) throw new InvalidUtfException(soff0);
                        value2 = 0;
                        value3 = 0;
                    }
                    if (!(validation.allowAnything() || (value2 & 0xC0) == 128 && (value3 & 0xC0) == 128)) {
                        throw new InvalidUtfException(soff0);
                    }
                    value = (value & 0xF) << 12 | (value2 & 0x3F) << 6 | value3 & 0x3F;
                    if (!validation.allowLongEncoding() && (value & 0xFFFFF800) == 0) {
                        throw new InvalidUtfException(soff0);
                    }
                } else {
                    if (!validation.allowAnything()) throw new InvalidUtfException(soff0);
                    value &= 0xFF;
                }
            } else if (!validation.allowSingleByteNul() && value == 0) {
                throw new InvalidUtfException(soff0);
            }
            if (dst != null) {
                dst[doff] = (char)value;
            }
            ++doff;
        }
        return doff - doff0;
    }

    public static char[] utf2chars(byte[] src, int sindex, int len, Validation validation) throws InvalidUtfException {
        char[] dst = new char[len];
        int len1 = Convert.utf2chars(src, sindex, dst, 0, len, validation);
        if (len1 == len) {
            return dst;
        }
        char[] result = new char[len1];
        System.arraycopy(dst, 0, result, 0, len1);
        return result;
    }

    public static String utf2string(byte[] src, int sindex, int len, Validation validation) throws InvalidUtfException {
        char[] dst = new char[len];
        int len1 = Convert.utf2chars(src, sindex, dst, 0, len, validation);
        return new String(dst, 0, len1);
    }

    public static int utfNumChars(byte[] buf, int off, int len) {
        int numChars = 0;
        while (len-- > 0) {
            if ((buf[off++] & 0xC0) == 128) continue;
            ++numChars;
        }
        return numChars;
    }

    public static int chars2utf(char[] src, int sindex, byte[] dst, int dindex, int len) {
        int j = dindex;
        int limit = sindex + len;
        for (int i = sindex; i < limit; ++i) {
            char ch = src[i];
            if ('\u0001' <= ch && ch <= '\u007f') {
                dst[j++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                dst[j++] = (byte)(0xC0 | ch >> 6);
                dst[j++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            dst[j++] = (byte)(0xE0 | ch >> 12);
            dst[j++] = (byte)(0x80 | ch >> 6 & 0x3F);
            dst[j++] = (byte)(0x80 | ch & 0x3F);
        }
        return j;
    }

    public static byte[] chars2utf(char[] src, int sindex, int len) {
        byte[] dst = new byte[len * 3];
        int len1 = Convert.chars2utf(src, sindex, dst, 0, len);
        byte[] result = new byte[len1];
        System.arraycopy(dst, 0, result, 0, len1);
        return result;
    }

    public static byte[] chars2utf(char[] src) {
        return Convert.chars2utf(src, 0, src.length);
    }

    public static byte[] string2utf(String s) {
        return Convert.chars2utf(s.toCharArray());
    }

    public static String quote(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            buf.append(Convert.quote(s.charAt(i), false));
        }
        return buf.toString();
    }

    public static String quote(char ch, boolean charContext) {
        switch (ch) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\'': {
                return charContext ? "\\'" : "'";
            }
            case '\"': {
                return charContext ? "\"" : "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Convert.isPrintableAscii(ch) ? String.valueOf(ch) : String.format("\\u%04x", ch);
    }

    private static boolean isPrintableAscii(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    public static String escapeUnicode(String s) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch > '\u00ff') {
                StringBuilder buf = new StringBuilder();
                buf.append(s.substring(0, i));
                while (i < len) {
                    ch = s.charAt(i);
                    if (ch > '\u00ff') {
                        buf.append("\\u");
                        buf.append(Character.forDigit((ch >> 12) % 16, 16));
                        buf.append(Character.forDigit((ch >> 8) % 16, 16));
                        buf.append(Character.forDigit((ch >> 4) % 16, 16));
                        buf.append(Character.forDigit(ch % 16, 16));
                    } else {
                        buf.append(ch);
                    }
                    ++i;
                }
                s = buf.toString();
                continue;
            }
            ++i;
        }
        return s;
    }

    public static Name shortName(Name name) {
        int start = name.lastIndexOfAscii('.') + 1;
        return start > 0 ? name.subName(start) : name;
    }

    public static String shortName(String name) {
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static Name packagePart(Name classname) {
        int end = Math.max(classname.lastIndexOfAscii('.'), 0);
        return classname.subName(0, end);
    }

    public static String packagePart(String classname) {
        int lastDot = classname.lastIndexOf(46);
        return lastDot < 0 ? "" : classname.substring(0, lastDot);
    }

    public static List<Name> enclosingCandidates(Name name) {
        int index;
        List<Name> names = List.nil();
        while ((index = name.lastIndexOfAscii('$')) > 0) {
            name = name.subName(0, index);
            names = names.prepend(name);
        }
        return names;
    }

    public static List<Name> classCandidates(Name name) {
        List<Name> names = List.nil();
        String nameStr = name.toString();
        int index = -1;
        while ((index = nameStr.indexOf(46, index + 1)) > 0) {
            String pack = nameStr.substring(0, index + 1);
            String clz = nameStr.substring(index + 1).replace('.', '$');
            names = names.prepend(name.table.names.fromString(pack + clz));
        }
        return names.reverse();
    }

    public static enum Validation {
        NONE(true, true, true),
        PREJDK14(true, true, false),
        STRICT(false, false, false);

        private final boolean allowSingleByteNul;
        private final boolean allowLongEncoding;
        private final boolean allowAnything;

        private Validation(boolean allowSingleByteNul, boolean allowLongEncoding, boolean allowAnything) {
            this.allowSingleByteNul = allowSingleByteNul;
            this.allowLongEncoding = allowLongEncoding;
            this.allowAnything = allowAnything;
        }

        public boolean allowSingleByteNul() {
            return this.allowSingleByteNul;
        }

        public boolean allowLongEncoding() {
            return this.allowLongEncoding;
        }

        public boolean allowAnything() {
            return this.allowAnything;
        }
    }
}

