/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.maxent.quasinewton;

import java.util.Arrays;
import opennlp.tools.ml.ArrayMath;
import opennlp.tools.ml.maxent.quasinewton.Function;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;

public class NegLogLikelihood
implements Function {
    protected final int dimension;
    protected final int numOutcomes;
    protected final int numFeatures;
    protected final int numContexts;
    protected final float[][] values;
    protected final int[][] contexts;
    protected final int[] outcomeList;
    protected final int[] numTimesEventsSeen;
    protected final double[] tempSums;
    protected final double[] expectation;
    protected final double[] gradient;

    public NegLogLikelihood(DataIndexer indexer) {
        this.values = (float[][])(indexer instanceof OnePassRealValueDataIndexer ? indexer.getValues() : null);
        this.contexts = indexer.getContexts();
        this.outcomeList = indexer.getOutcomeList();
        this.numTimesEventsSeen = indexer.getNumTimesEventsSeen();
        this.numOutcomes = indexer.getOutcomeLabels().length;
        this.numFeatures = indexer.getPredLabels().length;
        this.numContexts = this.contexts.length;
        this.dimension = this.numOutcomes * this.numFeatures;
        this.expectation = new double[this.numOutcomes];
        this.tempSums = new double[this.numOutcomes];
        this.gradient = new double[this.dimension];
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    public double[] getInitialPoint() {
        return new double[this.dimension];
    }

    @Override
    public double valueAt(double[] x) {
        if (x.length != this.dimension) {
            throw new IllegalArgumentException("x is invalid, its dimension is not equal to domain dimension.");
        }
        double negLogLikelihood = 0.0;
        for (int ci = 0; ci < this.numContexts; ++ci) {
            for (int oi = 0; oi < this.numOutcomes; ++oi) {
                this.tempSums[oi] = 0.0;
                for (int ai = 0; ai < this.contexts[ci].length; ++ai) {
                    int vectorIndex = this.indexOf(oi, this.contexts[ci][ai]);
                    double predValue = this.values != null ? (double)this.values[ci][ai] : 1.0;
                    int n = oi;
                    this.tempSums[n] = this.tempSums[n] + predValue * x[vectorIndex];
                }
            }
            double logSumOfExps = ArrayMath.logSumOfExps(this.tempSums);
            int outcome = this.outcomeList[ci];
            negLogLikelihood -= (this.tempSums[outcome] - logSumOfExps) * (double)this.numTimesEventsSeen[ci];
        }
        return negLogLikelihood;
    }

    @Override
    public double[] gradientAt(double[] x) {
        if (x.length != this.dimension) {
            throw new IllegalArgumentException("x is invalid, its dimension is not equal to the function.");
        }
        Arrays.fill(this.gradient, 0.0);
        for (int ci = 0; ci < this.numContexts; ++ci) {
            double predValue;
            int vectorIndex;
            int ai;
            int oi;
            for (oi = 0; oi < this.numOutcomes; ++oi) {
                this.expectation[oi] = 0.0;
                for (ai = 0; ai < this.contexts[ci].length; ++ai) {
                    vectorIndex = this.indexOf(oi, this.contexts[ci][ai]);
                    predValue = this.values != null ? (double)this.values[ci][ai] : 1.0;
                    int n = oi;
                    this.expectation[n] = this.expectation[n] + predValue * x[vectorIndex];
                }
            }
            double logSumOfExps = ArrayMath.logSumOfExps(this.expectation);
            for (oi = 0; oi < this.numOutcomes; ++oi) {
                this.expectation[oi] = StrictMath.exp(this.expectation[oi] - logSumOfExps);
            }
            for (oi = 0; oi < this.numOutcomes; ++oi) {
                boolean empirical = this.outcomeList[ci] == oi;
                for (ai = 0; ai < this.contexts[ci].length; ++ai) {
                    vectorIndex = this.indexOf(oi, this.contexts[ci][ai]);
                    predValue = this.values != null ? (double)this.values[ci][ai] : 1.0;
                    int n = vectorIndex;
                    this.gradient[n] = this.gradient[n] + predValue * (this.expectation[oi] - (double)empirical) * (double)this.numTimesEventsSeen[ci];
                }
            }
        }
        return this.gradient;
    }

    protected int indexOf(int outcomeId, int featureId) {
        return outcomeId * this.numFeatures + featureId;
    }
}

