/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.stats;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ExecutableInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.rest.stats.MethodExecStats;

public class MethodInvoker {
    private final MethodInfo m;
    private final MethodExecStats stats;

    public MethodInvoker(Method m, MethodExecStats stats) {
        this.m = MethodInfo.of((Method)m);
        this.stats = stats;
    }

    public ClassInfo getDeclaringClass() {
        return this.m.getDeclaringClass();
    }

    public String getFullName() {
        return this.m.getFullName();
    }

    public MethodExecStats getStats() {
        return this.stats;
    }

    public MethodInfo inner() {
        return this.m;
    }

    public Object invoke(BeanStore beanStore, Object o) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (beanStore.hasAllParams((ExecutableInfo)this.m)) {
            return this.invoke(o, beanStore.getParams((ExecutableInfo)this.m));
        }
        throw ThrowableUtils.illegalArg((String)"Could not find prerequisites to invoke method ''{0}'': {1}", (Object[])new Object[]{this.getFullName(), beanStore.getMissingParams((ExecutableInfo)this.m)});
    }

    public Object invoke(Object o, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        long startTime = System.nanoTime();
        this.stats.started();
        try {
            Object object = this.m.inner().invoke(o, args);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            this.stats.error(e);
            throw e;
        }
        catch (InvocationTargetException e) {
            this.stats.error(e.getTargetException());
            throw e;
        }
        finally {
            this.stats.finished(System.nanoTime() - startTime);
        }
    }
}

