/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.rangeonrange;

import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.facet.rangeonrange.Range;

public class DoubleRange
extends Range {
    public final double[] min;
    public final double[] max;

    public DoubleRange(String label, double minIn, boolean minInclusive, double maxIn, boolean maxInclusive) {
        super(label, 1);
        if (Double.isNaN(minIn)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            minIn = Math.nextUp(minIn);
        }
        if (Double.isNaN(maxIn)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            maxIn = Math.nextAfter(maxIn, Double.NEGATIVE_INFINITY);
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.min = new double[]{minIn};
        this.max = new double[]{maxIn};
    }

    public DoubleRange(String label, double[] min2, double[] max2) {
        super(label, min2.length);
        this.checkArgs(min2, max2);
        this.min = min2;
        this.max = max2;
    }

    public String toString() {
        return "DoubleRange(label: " + this.label + ", min: " + Arrays.toString(this.min) + ", max: " + Arrays.toString(this.max) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleRange doubleRange = (DoubleRange)o;
        return Arrays.equals(this.min, doubleRange.min) && Arrays.equals(this.max, doubleRange.max) && this.label.equals(doubleRange.label) && this.dims == doubleRange.dims;
    }

    public int hashCode() {
        return Objects.hash(this.label, Arrays.hashCode(this.min), Arrays.hashCode(this.max), this.dims);
    }

    private void checkArgs(double[] min2, double[] max2) {
        if (min2 == null || max2 == null || min2.length == 0 || max2.length == 0) {
            this.failNoMatch();
        }
        if (min2.length != max2.length) {
            this.failNoMatch();
        }
        for (int i = 0; i < min2.length; ++i) {
            if (!(min2[i] > max2[i])) continue;
            this.failNoMatch();
        }
    }
}

