/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.geosparql;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonWriter;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.servlets.BaseActionREST;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.geosparql.spatial.SpatialIndexConstants;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexLib;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexPerGraph;
import org.apache.jena.geosparql.spatial.index.v2.SpatialIndexerComputation;
import org.apache.jena.geosparql.spatial.task.BasicTask;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.syntax.syntaxtransform.QueryTransformOps;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.system.Txn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexerService
extends BaseActionREST {
    private static final Logger logger = LoggerFactory.getLogger(SpatialIndexerService.class);
    private static Gson gsonForSse = new Gson();
    private Map<Endpoint, EndpointClients> listenersByEndpoint = Collections.synchronizedMap(new IdentityHashMap());
    private static final Var graphVar = Var.alloc("g");
    private static final Var keywordVar = Var.alloc("keyword");
    private static final Query allGraphsQuery = QueryFactory.create("SELECT ?g { GRAPH ?g { } } ORDER BY ASC(?g)");
    private static final Query graphsByKeywordQuery = QueryFactory.create("SELECT ?g { GRAPH ?g { } FILTER(contains(lcase(str(?g)), ?keyword)) } ORDER BY ASC(?g)");

    private static Set<Node> extractGraphsFromRequest(DatasetGraph dsg, HttpAction action, boolean emptySelectionToAllGraphs) {
        Collection<String> strs;
        String uris = action.getRequest().getParameter("graph");
        if (uris == null || uris.isBlank()) {
            strs = List.of(Quad.defaultGraphIRI.toString(), Quad.unionGraph.toString());
        } else {
            TypeToken<List<String>> typeToken = new TypeToken<List<String>>(){};
            strs = gsonForSse.fromJson(uris, typeToken);
        }
        List<Node> rawGraphNodes = strs.stream().map(NodeFactory::createURI).distinct().toList();
        if (rawGraphNodes.isEmpty() && emptySelectionToAllGraphs) {
            rawGraphNodes = List.of(Quad.defaultGraphIRI, Quad.unionGraph);
        }
        Set uniqueGraphNodes = rawGraphNodes.stream().flatMap(node -> SpatialIndexerService.expandUnionGraphNode(new ArrayList(), dsg, node).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        return uniqueGraphNodes;
    }

    private static boolean isReplaceMode(HttpAction action) {
        String str2 = action.getRequest().getParameter("replaceMode");
        boolean result = str2 == null || str2.isBlank() ? false : Boolean.parseBoolean(str2);
        return result;
    }

    private static int getThreadCount(HttpAction action) {
        int result;
        String str2 = action.getRequest().getParameter("maxThreadCount");
        int n = result = str2 == null || str2.isBlank() ? 1 : Integer.parseInt(str2);
        if (result == 0) {
            result = Runtime.getRuntime().availableProcessors();
        }
        return result;
    }

    private static <C extends Collection<Node>> C expandUnionGraphNode(C accGraphs, DatasetGraph dsg, Node node) {
        if (Quad.isUnionGraph(node)) {
            SpatialIndexLib.accGraphNodes(accGraphs, dsg);
        } else {
            accGraphs.add((Node)node);
        }
        return accGraphs;
    }

    @Override
    protected void doGet(HttpAction action) {
        String command;
        String rawCommand = action.getRequestParameter("command");
        switch (command = Optional.ofNullable(rawCommand).orElse("webpage")) {
            case "webpage": {
                this.serveWebPage(action);
                break;
            }
            case "events": {
                this.serveEvents(action);
                break;
            }
            case "status": {
                this.serveStatus(action);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported command (via HTTP GET): " + command);
            }
        }
    }

    protected void serveWebPage(HttpAction action) {
        String resourceName = "spatial-indexer/index.html";
        String str2 = null;
        try (InputStream in = SpatialIndexerService.class.getClassLoader().getResourceAsStream(resourceName);){
            str2 = IOUtils.toString(in, StandardCharsets.UTF_8);
        }
        catch (IOException e2) {
            ServletOps.errorOccurred(e2.getMessage(), e2);
        }
        if (str2 == null) {
            ServletOps.error(500, "Failed to load classpath resource " + resourceName);
        } else {
            action.setResponseStatus(200);
            action.setResponseContentType("text/html");
            try (ServletOutputStream out = action.getResponseOutputStream();){
                IOUtils.write(str2, (OutputStream)out, StandardCharsets.UTF_8);
            }
            catch (IOException e3) {
                ServletOps.errorOccurred(e3);
            }
        }
    }

    protected BasicTask getActiveTask(HttpAction action) {
        DatasetGraph dsg = action.getDataset();
        Context cxt = dsg.getContext();
        BasicTask activeTask = (BasicTask)cxt.get(SpatialIndexConstants.symSpatialIndexTask);
        return activeTask;
    }

    @Override
    protected void doPost(HttpAction action) {
        try {
            String command;
            String rawCommand = action.getRequestParameter("command");
            switch (command = Optional.ofNullable(rawCommand).orElse("none")) {
                case "index": {
                    this.doIndex(action);
                    break;
                }
                case "clean": {
                    this.doClean(action);
                    break;
                }
                case "status": {
                    this.serveStatus(action);
                    break;
                }
                case "cancel": {
                    this.doCancel(action);
                    break;
                }
                case "graphs": {
                    this.serveGraphs(action);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported command (via HTTP POST): " + command);
                }
            }
        }
        catch (Throwable t) {
            action.log.error("An unexpected error occurred.", t);
            ServletOps.errorOccurred(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serveGraphs(HttpAction action) throws IOException {
        Query query2;
        long offset = Optional.ofNullable(action.getRequestParameter("offset")).map(Long::parseLong).orElse(Long.MIN_VALUE);
        long limit = Optional.ofNullable(action.getRequestParameter("limit")).map(Long::parseLong).orElse(Long.MIN_VALUE);
        String keyword = action.getRequestParameter("keyword");
        if (keyword != null) {
            query2 = graphsByKeywordQuery.cloneQuery();
            query2 = QueryTransformOps.syntaxSubstitute(query2, Map.of(keywordVar, NodeFactory.createLiteralString(keyword)));
        } else {
            query2 = allGraphsQuery.cloneQuery();
        }
        if (offset != Long.MIN_VALUE || limit != Long.MIN_VALUE) {
            query2.setLimit(limit);
            query2.setOffset(offset);
        }
        action.beginRead();
        try {
            DatasetGraph dsg = action.getActiveDSG();
            try (QueryExec qe = QueryExec.dataset(dsg).query(query2).build();
                 JsonWriter jsonWriter = gsonForSse.newJsonWriter(new OutputStreamWriter((OutputStream)action.getResponseOutputStream(), StandardCharsets.UTF_8));){
                RowSet rs = qe.select();
                jsonWriter.beginArray();
                jsonWriter.value(Quad.defaultGraphIRI.getURI());
                jsonWriter.value(Quad.unionGraph.getURI());
                while (rs.hasNext()) {
                    Binding b = rs.next();
                    Node n = b.get(graphVar);
                    if (!n.isURI()) continue;
                    String uri = n.getURI();
                    jsonWriter.value(uri);
                }
                jsonWriter.endArray();
                jsonWriter.flush();
            }
        }
        finally {
            action.endRead();
        }
    }

    protected void serveEvents(HttpAction action) {
        HttpServletRequest request = action.getRequest();
        HttpServletResponse response = action.getResponse();
        response.setContentType("text/event-stream");
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        AsyncContext asyncContext = request.startAsync();
        asyncContext.setTimeout(0L);
        Endpoint endpoint = action.getEndpoint();
        final Runnable[] disposeSseListener = new Runnable[]{null};
        asyncContext.addListener(new AsyncListener(){

            @Override
            public void onComplete(AsyncEvent event) {
                disposeSseListener[0].run();
            }

            @Override
            public void onTimeout(AsyncEvent event) {
                disposeSseListener[0].run();
            }

            @Override
            public void onError(AsyncEvent event) {
                disposeSseListener[0].run();
            }

            @Override
            public void onStartAsync(AsyncEvent event) {
            }
        });
        disposeSseListener[0] = () -> this.listenersByEndpoint.compute(endpoint, (et, clts) -> {
            EndpointClients r = clts;
            if (clts != null) {
                clts.eventListeners.remove(asyncContext);
                if (clts.eventListeners.isEmpty()) {
                    r = null;
                }
                return r;
            }
            return r;
        });
        this.listenersByEndpoint.compute(endpoint, (et, clients) -> {
            if (clients == null) {
                clients = new EndpointClients(this);
            }
            clients.eventListeners.put(asyncContext, disposeSseListener[0]);
            return clients;
        });
    }

    protected void doClean(HttpAction action) throws Exception {
        DatasetGraph dsg = action.getDataset();
        Endpoint endpoint = action.getEndpoint();
        BasicTask.TaskListener<BasicTask> taskListener = task -> {
            switch (task.getTaskState()) {
                case STARTING: {
                    JsonObject json2 = SpatialIndexerService.toJsonTaskStart(task.getStartTime(), null);
                    this.broadcastJson(endpoint, (JsonElement)json2);
                    break;
                }
                case TERMINATED: {
                    JsonObject json3 = SpatialIndexerService.toJsonTaskEnd(task.getEndTime(), task.getThrowable(), task.getStatusMessage());
                    this.broadcastJson(endpoint, (JsonElement)json3);
                    break;
                }
            }
        };
        try {
            SpatialIndexLib.scheduleOnceCleanTask(dsg, taskListener);
        }
        catch (Exception e2) {
            ServletOps.errorOccurred(e2.getMessage(), e2);
        }
    }

    protected void doCancel(HttpAction action) {
        String state;
        BasicTask task = this.getActiveTask(action);
        if (task != null) {
            state = "true";
            task.abort();
        } else {
            state = "false";
        }
        String jsonStr = String.format("{ \"stopped\": %s }", state);
        SpatialIndexerService.successJson(action, jsonStr);
    }

    protected void serveStatus(HttpAction action) {
        long time;
        BasicTask task = this.getActiveTask(action);
        JsonObject status = new JsonObject();
        if (task == null) {
            status.addProperty("isIndexing", false);
            time = 0L;
        } else {
            String msg;
            status.addProperty("isIndexing", !task.isTerminated());
            if (!task.isTerminated()) {
                status.addProperty("isAborting", task.isAborting());
                time = !task.isAborting() ? task.getStartTime() : task.getAbortTime();
            } else {
                time = task.getEndTime();
            }
            Throwable throwable = task.getThrowable();
            if (throwable != null) {
                msg = ExceptionUtils.getStackTrace(throwable);
                status.addProperty("error", msg);
            }
            if ((msg = task.getStatusMessage()) != null) {
                status.addProperty("message", msg);
            }
        }
        status.addProperty("time", time);
        String jsonStr = gsonForSse.toJson(status);
        SpatialIndexerService.successJson(action, jsonStr);
    }

    protected BasicTask scheduleIndexTask(HttpAction action, SpatialIndexerComputation indexComputation, Path targetFile, boolean isReplaceTask) {
        final Endpoint endpoint = action.getEndpoint();
        DatasetGraph dsg = action.getDataset();
        final long graphCount = indexComputation.getGraphNodes().size();
        BasicTask.TaskListener<BasicTask> taskListener = new BasicTask.TaskListener<BasicTask>(){

            @Override
            public void onStateChange(BasicTask task) {
                switch (task.getTaskState()) {
                    case STARTING: {
                        JsonObject json2 = SpatialIndexerService.toJsonTaskStart(task.getStartTime(), null);
                        SpatialIndexerService.this.broadcastJson(endpoint, (JsonElement)json2);
                        break;
                    }
                    case ABORTING: {
                        JsonObject json3 = SpatialIndexerService.toJsonTaskAbort(task.getAbortTime(), null);
                        SpatialIndexerService.this.broadcastJson(endpoint, (JsonElement)json3);
                        break;
                    }
                    case TERMINATED: {
                        Throwable throwable = task.getThrowable();
                        long endTime = task.getEndTime();
                        JsonObject json4 = SpatialIndexerService.toJsonTaskEnd(endTime, throwable, task.getStatusMessage());
                        SpatialIndexerService.this.broadcastJson(endpoint, (JsonElement)json4);
                        if (!logger.isInfoEnabled()) break;
                        logger.info("Indexing task of {} graphs terminated.", (Object)graphCount);
                        break;
                    }
                }
            }
        };
        return SpatialIndexLib.scheduleOnceIndexTask(dsg, indexComputation, targetFile, isReplaceTask, taskListener);
    }

    protected void doIndex(HttpAction action) throws Exception {
        DatasetGraph dsg = action.getDataset();
        Object index = SpatialIndexLib.getSpatialIndex(dsg.getContext());
        if (index == null) {
            String msg = String.format("[%d] No spatial index has been configured for the dataset", action.id);
            action.log.error(msg);
            ServletOps.error(503, msg);
        } else {
            boolean isReplaceMode = SpatialIndexerService.isReplaceMode(action);
            boolean isUpdateMode = !isReplaceMode;
            int threadCount = SpatialIndexerService.getThreadCount(action);
            if (!(index instanceof SpatialIndexPerGraph) && isUpdateMode) {
                throw new RuntimeException("Cannot update existing spatial index because its type is unsupported. Consider replacing the index.");
            }
            Path oldLocation = index.getLocation();
            if (oldLocation == null) {
                action.log.warn("Spatial index will not be persisted because no file location was configured.");
            }
            String srsURI = index.getSrsInfo().getSrsURI();
            ArrayList<Node> graphNodes = new ArrayList<Node>(Txn.calculateRead(dsg, () -> SpatialIndexerService.extractGraphsFromRequest(dsg, action, isUpdateMode)));
            SpatialIndexerComputation task = new SpatialIndexerComputation(dsg, srsURI, graphNodes, threadCount);
            action.log.info(String.format("[%d] spatial index: computation request accepted.", action.id));
            try {
                this.scheduleIndexTask(action, task, oldLocation, isReplaceMode);
                SpatialIndexerService.successText(action, "Spatial index computation task accepted at " + DateTimeUtils.nowAsXSDDateTimeString());
            }
            catch (Exception e2) {
                ServletOps.errorOccurred(e2.getMessage(), e2);
            }
        }
    }

    protected static JsonObject toJsonTaskStart(long timeInMillis, String msg) {
        JsonObject json2 = new JsonObject();
        json2.addProperty("isIndexing", true);
        json2.addProperty("time", timeInMillis);
        if (msg != null) {
            json2.addProperty("message", msg);
        }
        return json2;
    }

    protected static JsonObject toJsonTaskAbort(long timeInMillis, String msg) {
        JsonObject json2 = new JsonObject();
        json2.addProperty("isIndexing", true);
        json2.addProperty("isAborting", true);
        json2.addProperty("time", timeInMillis);
        if (msg != null) {
            json2.addProperty("message", msg);
        }
        return json2;
    }

    protected static JsonObject toJsonTaskEnd(long timeInMillis, Throwable throwable, String msg) {
        JsonObject json2 = new JsonObject();
        json2.addProperty("isIndexing", false);
        json2.addProperty("time", timeInMillis);
        if (msg != null) {
            json2.addProperty("message", msg);
        }
        if (throwable != null) {
            json2.addProperty("error", ExceptionUtils.getStackTrace(throwable));
        }
        return json2;
    }

    protected void broadcastJson(Endpoint endpoint, JsonElement jsonData) {
        EndpointClients clients = this.listenersByEndpoint.get(endpoint);
        if (clients != null) {
            Iterator<Map.Entry<AsyncContext, Runnable>> it = clients.eventListeners.entrySet().iterator();
            this.broadcastJson(it, jsonData);
        }
    }

    protected void broadcastJson(Iterator<Map.Entry<AsyncContext, Runnable>> it, JsonElement jsonData) {
        String str2 = gsonForSse.toJson(jsonData);
        this.broadcastLine(it, str2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastLine(Iterator<Map.Entry<AsyncContext, Runnable>> it, String payload) {
        while (it.hasNext()) {
            Map.Entry<AsyncContext, Runnable> e2 = it.next();
            AsyncContext context2 = e2.getKey();
            Runnable unregister = e2.getValue();
            try {
                PrintWriter writer = context2.getResponse().getWriter();
                writer.println("data: " + payload);
                writer.println();
                writer.flush();
            }
            catch (Throwable x) {
                it.remove();
                logger.warn("Broadcast failed.", x);
                try {
                    unregister.run();
                }
                finally {
                    context2.complete();
                }
            }
        }
    }

    protected static void successText(HttpAction action, String jsonStr) {
        SpatialIndexerService.successStringUtf8(action, "text/plain", jsonStr);
    }

    protected static void successJson(HttpAction action, String jsonStr) {
        SpatialIndexerService.successStringUtf8(action, "application/json", jsonStr);
    }

    protected static void successStringUtf8(HttpAction action, String contentType, String str2) {
        action.setResponseContentType(contentType);
        action.setResponseCharacterEncoding("utf-8");
        action.setResponseStatus(200);
        try {
            action.getResponseOutputStream().println(str2);
        }
        catch (IOException e2) {
            IO.exception(e2);
        }
    }

    private class EndpointClients {
        Map<AsyncContext, Runnable> eventListeners = Collections.synchronizedMap(new IdentityHashMap());

        private EndpointClients(SpatialIndexerService spatialIndexerService) {
        }
    }
}

