/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.servlet;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.apache.shiro.web.servlet.NameableFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OncePerRequestFilter
extends NameableFilter {
    public static final String ALREADY_FILTERED_SUFFIX = ".FILTERED";
    private static final Logger LOGGER = LoggerFactory.getLogger(OncePerRequestFilter.class);
    private boolean enabled = true;
    private boolean filterOncePerRequest;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isFilterOncePerRequest() {
        return this.filterOncePerRequest;
    }

    public void setFilterOncePerRequest(boolean filterOncePerRequest) {
        this.filterOncePerRequest = filterOncePerRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String alreadyFilteredAttributeName = this.getAlreadyFilteredAttributeName();
        if (request.getAttribute(alreadyFilteredAttributeName) != null && this.filterOncePerRequest) {
            LOGGER.trace("Filter '{}' already executed.  Proceeding without invoking this filter.", (Object)this.getName());
            filterChain.doFilter(request, response);
        } else if (!this.isEnabled(request, response) || this.shouldNotFilter(request)) {
            LOGGER.debug("Filter '{}' is not enabled for the current request.  Proceeding without invoking this filter.", (Object)this.getName());
            filterChain.doFilter(request, response);
        } else {
            LOGGER.trace("Filter '{}' not yet executed.  Executing now.", (Object)this.getName());
            request.setAttribute(alreadyFilteredAttributeName, Boolean.TRUE);
            try {
                this.doFilterInternal(request, response, filterChain);
            }
            finally {
                request.removeAttribute(alreadyFilteredAttributeName);
            }
        }
    }

    protected boolean isEnabled(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        return this.isEnabled();
    }

    protected String getAlreadyFilteredAttributeName() {
        String name = this.getName();
        if (name == null) {
            name = this.getClass().getName();
        }
        return name + ALREADY_FILTERED_SUFFIX;
    }

    @Deprecated
    protected boolean shouldNotFilter(ServletRequest request) throws ServletException {
        return false;
    }

    protected abstract void doFilterInternal(ServletRequest var1, ServletResponse var2, FilterChain var3) throws ServletException, IOException;
}

