/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml;

import java.io.Reader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.lucene.queryparser.xml.ParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DOMUtils {
    public static Element getChildByTagOrFail(Element e2, String name) throws ParserException {
        Element kid = DOMUtils.getChildByTagName(e2, name);
        if (null == kid) {
            throw new ParserException(e2.getTagName() + " missing \"" + name + "\" child element");
        }
        return kid;
    }

    public static Element getFirstChildOrFail(Element e2) throws ParserException {
        Element kid = DOMUtils.getFirstChildElement(e2);
        if (null == kid) {
            throw new ParserException(e2.getTagName() + " does not contain a child element");
        }
        return kid;
    }

    public static String getAttributeOrFail(Element e2, String name) throws ParserException {
        String v = e2.getAttribute(name);
        if (null == v) {
            throw new ParserException(e2.getTagName() + " missing \"" + name + "\" attribute");
        }
        return v;
    }

    public static String getAttributeWithInheritanceOrFail(Element e2, String name) throws ParserException {
        String v = DOMUtils.getAttributeWithInheritance(e2, name);
        if (null == v) {
            throw new ParserException(e2.getTagName() + " missing \"" + name + "\" attribute");
        }
        return v;
    }

    public static String getNonBlankTextOrFail(Element e2) throws ParserException {
        String v = DOMUtils.getText(e2);
        if (null != v) {
            v = v.trim();
        }
        if (null == v || 0 == v.length()) {
            throw new ParserException(e2.getTagName() + " has no text");
        }
        return v;
    }

    public static Element getChildByTagName(Element e2, String name) {
        for (Node kid = e2.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1 || !name.equals(kid.getNodeName())) continue;
            return (Element)kid;
        }
        return null;
    }

    public static String getAttributeWithInheritance(Element element, String attributeName) {
        String result = element.getAttribute(attributeName);
        if (result == null || result.isEmpty()) {
            Node n = element.getParentNode();
            if (n == element || n == null) {
                return null;
            }
            if (n instanceof Element) {
                Element parent = (Element)n;
                return DOMUtils.getAttributeWithInheritance(parent, attributeName);
            }
            return null;
        }
        return result;
    }

    public static String getChildTextByTagName(Element e2, String tagName) {
        Element child = DOMUtils.getChildByTagName(e2, tagName);
        return child != null ? DOMUtils.getText(child) : null;
    }

    public static Element insertChild(Element parent, String tagName, String text) {
        Element child = parent.getOwnerDocument().createElement(tagName);
        parent.appendChild(child);
        if (text != null) {
            child.appendChild(child.getOwnerDocument().createTextNode(text));
        }
        return child;
    }

    public static String getAttribute(Element element, String attributeName, String deflt) {
        String result = element.getAttribute(attributeName);
        return result == null || result.isEmpty() ? deflt : result;
    }

    public static float getAttribute(Element element, String attributeName, float deflt) {
        String result = element.getAttribute(attributeName);
        return result == null || result.isEmpty() ? deflt : Float.parseFloat(result);
    }

    public static int getAttribute(Element element, String attributeName, int deflt) {
        String result = element.getAttribute(attributeName);
        return result == null || result.isEmpty() ? deflt : Integer.parseInt(result);
    }

    public static boolean getAttribute(Element element, String attributeName, boolean deflt) {
        String result = element.getAttribute(attributeName);
        return result == null || result.isEmpty() ? deflt : Boolean.valueOf(result);
    }

    public static String getText(Node e2) {
        StringBuilder sb = new StringBuilder();
        DOMUtils.getTextBuffer(e2, sb);
        return sb.toString();
    }

    public static Element getFirstChildElement(Element element) {
        for (Node kid = element.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid.getNodeType() != 1) continue;
            return (Element)kid;
        }
        return null;
    }

    private static void getTextBuffer(Node e2, StringBuilder sb) {
        block5: for (Node kid = e2.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            switch (kid.getNodeType()) {
                case 3: {
                    sb.append(kid.getNodeValue());
                    continue block5;
                }
                case 1: {
                    DOMUtils.getTextBuffer(kid, sb);
                    continue block5;
                }
                case 5: {
                    DOMUtils.getTextBuffer(kid, sb);
                }
            }
        }
    }

    public static Document loadXML(Reader is) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception se) {
            throw new RuntimeException("Parser configuration error", se);
        }
        Document doc = null;
        try {
            doc = db.parse(new InputSource(is));
        }
        catch (Exception se) {
            throw new RuntimeException("Error parsing file:" + String.valueOf(se), se);
        }
        return doc;
    }
}

