/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Iterator;
import java.util.stream.Stream;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraphBase;
import org.apache.jena.sparql.core.Quad;

public abstract class DatasetGraphBaseFind
extends DatasetGraphBase {
    protected DatasetGraphBaseFind() {
    }

    @Override
    public Iterator<Quad> find(Node g, Node s, Node p, Node o) {
        if (Quad.isDefaultGraph(g)) {
            return this.findInDftGraph(s, p, o);
        }
        if (!DatasetGraphBaseFind.isWildcard(g)) {
            return this.findNG(g, s, p, o);
        }
        return this.findAny(s, p, o);
    }

    @Override
    public Iterator<Quad> findNG(Node g, Node s, Node p, Node o) {
        Iterator<Quad> qIter = Quad.isUnionGraph(g) ? this.findQuadsInUnionGraph(s, p, o) : (DatasetGraphBaseFind.isWildcard(g) ? this.findInAnyNamedGraphs(s, p, o) : (Quad.isDefaultGraph(g) ? this.findInDftGraph(s, p, o) : this.findInSpecificNamedGraph(g, s, p, o)));
        if (qIter == null) {
            return Iter.nullIterator();
        }
        return qIter;
    }

    protected Iterator<Quad> findAny(Node s, Node p, Node o) {
        Iterator<Quad> iter2;
        Iterator<Quad> iter1 = this.findInDftGraph(s, p, o);
        if (!iter1.hasNext()) {
            iter1 = null;
        }
        if (!(iter2 = this.findInAnyNamedGraphs(s, p, o)).hasNext()) {
            iter2 = null;
        }
        return Iter.append(iter1, iter2);
    }

    protected abstract Iterator<Quad> findInDftGraph(Node var1, Node var2, Node var3);

    public Iterator<Triple> findInUnionGraph(Node s, Node p, Node o) {
        return this.findUnionGraphTriples(s, p, o).iterator();
    }

    public Iterator<Quad> findQuadsInUnionGraph(Node s, Node p, Node o) {
        return this.findUnionGraphTriples(s, p, o).map(t -> Quad.create(Quad.unionGraph, t)).iterator();
    }

    private Stream<Triple> findUnionGraphTriples(Node s, Node p, Node o) {
        return Iter.asStream(this.findInAnyNamedGraphs(s, p, o)).map(Quad::asTriple).distinct();
    }

    protected abstract Iterator<Quad> findInSpecificNamedGraph(Node var1, Node var2, Node var3, Node var4);

    protected abstract Iterator<Quad> findInAnyNamedGraphs(Node var1, Node var2, Node var3);
}

