/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.solver;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.iterator.Abortable;
import org.apache.jena.sparql.engine.iterator.IterAbortable;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;

public class SolverLib {
    public static <T> Iterator<T> makeAbortable(Iterator<T> iter, List<Abortable> killList, AtomicBoolean cancel) {
        if (killList == null) {
            return iter;
        }
        IterAbortable<T> k = IterAbortable.wrap(iter, cancel);
        killList.add(k);
        return k;
    }

    public static boolean tripleHasNodeTriple(Triple triple) {
        return triple.getSubject().isTripleTerm() || triple.getObject().isTripleTerm();
    }

    public static boolean quadHasNodeTriple(Quad quad) {
        return quad.getSubject().isTripleTerm() || quad.getObject().isTripleTerm();
    }

    public static boolean tripleHasEmbTripleWithVars(Triple triple) {
        return SolverLib.isTripleTermWithVars(triple.getSubject()) || SolverLib.isTripleTermWithVars(triple.getObject());
    }

    public static boolean quadHasEmbTripleWithVars(Quad quad) {
        return SolverLib.isTripleTermWithVars(quad.getSubject()) || SolverLib.isTripleTermWithVars(quad.getObject());
    }

    private static boolean isTripleTermWithVars(Node node) {
        if (!node.isTripleTerm()) {
            return false;
        }
        return !node.getTriple().isConcrete();
    }

    public static boolean sameTermAs(Node node1, Node node2) {
        return NodeFunctions.sameTerm(node1, node2);
    }

    public static Node nodeTopLevel(Node node) {
        if (Var.isVar(node)) {
            return Node.ANY;
        }
        if (node.isTripleTerm() && !node.getTriple().isConcrete()) {
            return Node.ANY;
        }
        return node;
    }
}

