/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.source;

import java.util.Optional;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeUnion;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanVisitor;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorRelationalPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeCreateTableOrViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteDevicesPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AbstractTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.AddTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.CommitDeleteTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTableColumnPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.RenameTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableColumnCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTableCommentPlan;
import org.apache.iotdb.confignode.consensus.request.write.table.SetTablePropertiesPlan;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.rpc.TSStatusCode;

public class PipeConfigPhysicalPlanTablePrivilegeParseVisitor
extends ConfigPhysicalPlanVisitor<Optional<ConfigPhysicalPlan>, String> {
    @Override
    public Optional<ConfigPhysicalPlan> visitPlan(ConfigPhysicalPlan plan, String userName) {
        return Optional.of(plan);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCreateDatabase(DatabaseSchemaPlan createDatabasePlan, String userName) {
        return this.visitDatabaseSchemaPlan(createDatabasePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitAlterDatabase(DatabaseSchemaPlan alterDatabasePlan, String userName) {
        return this.visitDatabaseSchemaPlan(alterDatabasePlan, userName);
    }

    public Optional<ConfigPhysicalPlan> visitDatabaseSchemaPlan(DatabaseSchemaPlan databaseSchemaPlan, String userName) {
        return ConfigNode.getInstance().getConfigManager().getPermissionManager().checkUserPrivileges(userName, new PrivilegeUnion(databaseSchemaPlan.getSchema().getName(), null)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? Optional.of(databaseSchemaPlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitDeleteDatabase(DeleteDatabasePlan deleteDatabasePlan, String userName) {
        return ConfigNode.getInstance().getConfigManager().getPermissionManager().checkUserPrivileges(userName, new PrivilegeUnion(deleteDatabasePlan.getName(), null)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? Optional.of(deleteDatabasePlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeCreateTableOrView(PipeCreateTableOrViewPlan pipeCreateTableOrViewPlan, String userName) {
        return ConfigNode.getInstance().getConfigManager().getPermissionManager().checkUserPrivileges(userName, new PrivilegeUnion(pipeCreateTableOrViewPlan.getDatabase(), pipeCreateTableOrViewPlan.getTable().getTableName(), null)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? Optional.of(pipeCreateTableOrViewPlan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitAddTableColumn(AddTableColumnPlan addTableColumnPlan, String userName) {
        return this.visitAbstractTablePlan(addTableColumnPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitSetTableProperties(SetTablePropertiesPlan setTablePropertiesPlan, String userName) {
        return this.visitAbstractTablePlan(setTablePropertiesPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCommitDeleteColumn(CommitDeleteColumnPlan commitDeleteColumnPlan, String userName) {
        return this.visitAbstractTablePlan(commitDeleteColumnPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRenameTableColumn(RenameTableColumnPlan renameTableColumnPlan, String userName) {
        return this.visitAbstractTablePlan(renameTableColumnPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitCommitDeleteTable(CommitDeleteTablePlan commitDeleteTablePlan, String userName) {
        return this.visitAbstractTablePlan(commitDeleteTablePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitPipeDeleteDevices(PipeDeleteDevicesPlan pipeDeleteDevicesPlan, String userName) {
        return this.visitAbstractTablePlan(pipeDeleteDevicesPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitSetTableComment(SetTableCommentPlan setTableCommentPlan, String userName) {
        return this.visitAbstractTablePlan(setTableCommentPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitSetTableColumnComment(SetTableColumnCommentPlan setTableColumnCommentPlan, String userName) {
        return this.visitAbstractTablePlan(setTableColumnCommentPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRenameTable(RenameTablePlan renameTablePlan, String userName) {
        return this.visitAbstractTablePlan(renameTablePlan, userName);
    }

    private Optional<ConfigPhysicalPlan> visitAbstractTablePlan(AbstractTablePlan plan, String userName) {
        return ConfigNode.getInstance().getConfigManager().getPermissionManager().checkUserPrivileges(userName, new PrivilegeUnion(plan.getDatabase(), plan.getTableName(), null)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? Optional.of(plan) : Optional.empty();
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRCreateUser(AuthorRelationalPlan rCreateUserPlan, String userName) {
        return this.visitUserPlan(rCreateUserPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRCreateRole(AuthorRelationalPlan rCreateRolePlan, String userName) {
        return this.visitRolePlan(rCreateRolePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRUpdateUser(AuthorRelationalPlan rUpdateUserPlan, String userName) {
        return this.visitUserPlan(rUpdateUserPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRDropUserPlan(AuthorRelationalPlan rDropUserPlan, String userName) {
        return this.visitUserPlan(rDropUserPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRDropRolePlan(AuthorRelationalPlan rDropRolePlan, String userName) {
        return this.visitRolePlan(rDropRolePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserRole(AuthorRelationalPlan rGrantUserRolePlan, String userName) {
        return this.visitUserRolePlan(rGrantUserRolePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserRole(AuthorRelationalPlan rRevokeUserRolePlan, String userName) {
        return this.visitUserRolePlan(rRevokeUserRolePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserAny(AuthorRelationalPlan rGrantUserAnyPlan, String userName) {
        return this.visitUserPlan(rGrantUserAnyPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantRoleAny(AuthorRelationalPlan rGrantRoleAnyPlan, String userName) {
        return this.visitRolePlan(rGrantRoleAnyPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserAll(AuthorRelationalPlan rGrantUserAllPlan, String userName) {
        return this.visitUserPlan(rGrantUserAllPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantRoleAll(AuthorRelationalPlan rGrantRoleAllPlan, String userName) {
        return this.visitRolePlan(rGrantRoleAllPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserDB(AuthorRelationalPlan rGrantUserDBPlan, String userName) {
        return this.visitUserPlan(rGrantUserDBPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserTB(AuthorRelationalPlan rGrantUserTBPlan, String userName) {
        return this.visitUserPlan(rGrantUserTBPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantRoleDB(AuthorRelationalPlan rGrantRoleDBPlan, String userName) {
        return this.visitRolePlan(rGrantRoleDBPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantRoleTB(AuthorRelationalPlan rGrantRoleTBPlan, String userName) {
        return this.visitRolePlan(rGrantRoleTBPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserAny(AuthorRelationalPlan rRevokeUserAnyPlan, String userName) {
        return this.visitUserPlan(rRevokeUserAnyPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeRoleAny(AuthorRelationalPlan rRevokeRoleAnyPlan, String userName) {
        return this.visitRolePlan(rRevokeRoleAnyPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserAll(AuthorRelationalPlan rRevokeUserAllPlan, String userName) {
        return this.visitUserPlan(rRevokeUserAllPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeRoleAll(AuthorRelationalPlan rRevokeRoleAllPlan, String userName) {
        return this.visitRolePlan(rRevokeRoleAllPlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserDBPrivilege(AuthorRelationalPlan rRevokeUserDBPrivilegePlan, String userName) {
        return this.visitUserPlan(rRevokeUserDBPrivilegePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserTBPrivilege(AuthorRelationalPlan rRevokeUserTBPrivilegePlan, String userName) {
        return this.visitUserPlan(rRevokeUserTBPrivilegePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeRoleDBPrivilege(AuthorRelationalPlan rRevokeRoleTBPrivilegePlan, String userName) {
        return this.visitRolePlan(rRevokeRoleTBPrivilegePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeRoleTBPrivilege(AuthorRelationalPlan rRevokeRoleTBPrivilegePlan, String userName) {
        return this.visitRolePlan(rRevokeRoleTBPrivilegePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantUserSysPrivilege(AuthorRelationalPlan rGrantUserSysPrivilegePlan, String userName) {
        return this.visitUserPlan(rGrantUserSysPrivilegePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRGrantRoleSysPrivilege(AuthorRelationalPlan rGrantRoleSysPrivilegePlan, String userName) {
        return this.visitRolePlan(rGrantRoleSysPrivilegePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeUserSysPrivilege(AuthorRelationalPlan rRevokeUserSysPrivilegePlan, String userName) {
        return this.visitUserPlan(rRevokeUserSysPrivilegePlan, userName);
    }

    @Override
    public Optional<ConfigPhysicalPlan> visitRRevokeRoleSysPrivilege(AuthorRelationalPlan rRevokeRoleSysPrivilegePlan, String userName) {
        return this.visitRolePlan(rRevokeRoleSysPrivilegePlan, userName);
    }

    private Optional<ConfigPhysicalPlan> visitUserPlan(AuthorRelationalPlan plan, String userName) {
        return ConfigNode.getInstance().getConfigManager().getPermissionManager().checkUserPrivileges(userName, new PrivilegeUnion(PrivilegeType.MANAGE_USER)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? Optional.of(plan) : Optional.empty();
    }

    private Optional<ConfigPhysicalPlan> visitRolePlan(AuthorRelationalPlan plan, String userName) {
        return ConfigNode.getInstance().getConfigManager().getPermissionManager().checkUserPrivileges(userName, new PrivilegeUnion(PrivilegeType.MANAGE_ROLE)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? Optional.of(plan) : Optional.empty();
    }

    private Optional<ConfigPhysicalPlan> visitUserRolePlan(AuthorRelationalPlan plan, String userName) {
        return ConfigNode.getInstance().getConfigManager().getPermissionManager().checkUserPrivileges(userName, new PrivilegeUnion(PrivilegeType.MANAGE_ROLE)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || ConfigNode.getInstance().getConfigManager().getPermissionManager().checkUserPrivileges(userName, new PrivilegeUnion(PrivilegeType.MANAGE_USER)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() ? Optional.of(plan) : Optional.empty();
    }
}

