/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ApplicationDescription
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=308");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=309");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=310");
    private final String applicationUri;
    private final String productUri;
    private final LocalizedText applicationName;
    private final ApplicationType applicationType;
    private final String gatewayServerUri;
    private final String discoveryProfileUri;
    private final String[] discoveryUrls;

    public ApplicationDescription(String applicationUri, String productUri, LocalizedText applicationName, ApplicationType applicationType, String gatewayServerUri, String discoveryProfileUri, String[] discoveryUrls) {
        this.applicationUri = applicationUri;
        this.productUri = productUri;
        this.applicationName = applicationName;
        this.applicationType = applicationType;
        this.gatewayServerUri = gatewayServerUri;
        this.discoveryProfileUri = discoveryProfileUri;
        this.discoveryUrls = discoveryUrls;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public LocalizedText getApplicationName() {
        return this.applicationName;
    }

    public ApplicationType getApplicationType() {
        return this.applicationType;
    }

    public String getGatewayServerUri() {
        return this.gatewayServerUri;
    }

    public String getDiscoveryProfileUri() {
        return this.discoveryProfileUri;
    }

    public String[] getDiscoveryUrls() {
        return this.discoveryUrls;
    }

    protected ApplicationDescription(ApplicationDescriptionBuilder<?, ?> b) {
        super(b);
        this.applicationUri = ((ApplicationDescriptionBuilder)b).applicationUri;
        this.productUri = ((ApplicationDescriptionBuilder)b).productUri;
        this.applicationName = ((ApplicationDescriptionBuilder)b).applicationName;
        this.applicationType = ((ApplicationDescriptionBuilder)b).applicationType;
        this.gatewayServerUri = ((ApplicationDescriptionBuilder)b).gatewayServerUri;
        this.discoveryProfileUri = ((ApplicationDescriptionBuilder)b).discoveryProfileUri;
        this.discoveryUrls = ((ApplicationDescriptionBuilder)b).discoveryUrls;
    }

    public static ApplicationDescriptionBuilder<?, ?> builder() {
        return new ApplicationDescriptionBuilderImpl();
    }

    public ApplicationDescriptionBuilder<?, ?> toBuilder() {
        return new ApplicationDescriptionBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApplicationDescription)) {
            return false;
        }
        ApplicationDescription other = (ApplicationDescription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$applicationUri = this.getApplicationUri();
        String other$applicationUri = other.getApplicationUri();
        if (this$applicationUri == null ? other$applicationUri != null : !this$applicationUri.equals(other$applicationUri)) {
            return false;
        }
        String this$productUri = this.getProductUri();
        String other$productUri = other.getProductUri();
        if (this$productUri == null ? other$productUri != null : !this$productUri.equals(other$productUri)) {
            return false;
        }
        LocalizedText this$applicationName = this.getApplicationName();
        LocalizedText other$applicationName = other.getApplicationName();
        if (this$applicationName == null ? other$applicationName != null : !((Object)this$applicationName).equals(other$applicationName)) {
            return false;
        }
        ApplicationType this$applicationType = this.getApplicationType();
        ApplicationType other$applicationType = other.getApplicationType();
        if (this$applicationType == null ? other$applicationType != null : !this$applicationType.equals(other$applicationType)) {
            return false;
        }
        String this$gatewayServerUri = this.getGatewayServerUri();
        String other$gatewayServerUri = other.getGatewayServerUri();
        if (this$gatewayServerUri == null ? other$gatewayServerUri != null : !this$gatewayServerUri.equals(other$gatewayServerUri)) {
            return false;
        }
        String this$discoveryProfileUri = this.getDiscoveryProfileUri();
        String other$discoveryProfileUri = other.getDiscoveryProfileUri();
        if (this$discoveryProfileUri == null ? other$discoveryProfileUri != null : !this$discoveryProfileUri.equals(other$discoveryProfileUri)) {
            return false;
        }
        return Arrays.deepEquals(this.getDiscoveryUrls(), other.getDiscoveryUrls());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApplicationDescription;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $applicationUri = this.getApplicationUri();
        result = result * 59 + ($applicationUri == null ? 43 : $applicationUri.hashCode());
        String $productUri = this.getProductUri();
        result = result * 59 + ($productUri == null ? 43 : $productUri.hashCode());
        LocalizedText $applicationName = this.getApplicationName();
        result = result * 59 + ($applicationName == null ? 43 : ((Object)$applicationName).hashCode());
        ApplicationType $applicationType = this.getApplicationType();
        result = result * 59 + ($applicationType == null ? 43 : $applicationType.hashCode());
        String $gatewayServerUri = this.getGatewayServerUri();
        result = result * 59 + ($gatewayServerUri == null ? 43 : $gatewayServerUri.hashCode());
        String $discoveryProfileUri = this.getDiscoveryProfileUri();
        result = result * 59 + ($discoveryProfileUri == null ? 43 : $discoveryProfileUri.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getDiscoveryUrls());
        return result;
    }

    @Override
    public String toString() {
        return "ApplicationDescription(applicationUri=" + this.getApplicationUri() + ", productUri=" + this.getProductUri() + ", applicationName=" + this.getApplicationName() + ", applicationType=" + this.getApplicationType() + ", gatewayServerUri=" + this.getGatewayServerUri() + ", discoveryProfileUri=" + this.getDiscoveryProfileUri() + ", discoveryUrls=" + Arrays.deepToString(this.getDiscoveryUrls()) + ")";
    }

    private static final class ApplicationDescriptionBuilderImpl
    extends ApplicationDescriptionBuilder<ApplicationDescription, ApplicationDescriptionBuilderImpl> {
        private ApplicationDescriptionBuilderImpl() {
        }

        @Override
        protected ApplicationDescriptionBuilderImpl self() {
            return this;
        }

        @Override
        public ApplicationDescription build() {
            return new ApplicationDescription(this);
        }
    }

    public static abstract class ApplicationDescriptionBuilder<C extends ApplicationDescription, B extends ApplicationDescriptionBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private String applicationUri;
        private String productUri;
        private LocalizedText applicationName;
        private ApplicationType applicationType;
        private String gatewayServerUri;
        private String discoveryProfileUri;
        private String[] discoveryUrls;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ApplicationDescriptionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ApplicationDescription instance, ApplicationDescriptionBuilder<?, ?> b) {
            b.applicationUri(instance.applicationUri);
            b.productUri(instance.productUri);
            b.applicationName(instance.applicationName);
            b.applicationType(instance.applicationType);
            b.gatewayServerUri(instance.gatewayServerUri);
            b.discoveryProfileUri(instance.discoveryProfileUri);
            b.discoveryUrls(instance.discoveryUrls);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B applicationUri(String applicationUri) {
            this.applicationUri = applicationUri;
            return (B)this.self();
        }

        public B productUri(String productUri) {
            this.productUri = productUri;
            return (B)this.self();
        }

        public B applicationName(LocalizedText applicationName) {
            this.applicationName = applicationName;
            return (B)this.self();
        }

        public B applicationType(ApplicationType applicationType) {
            this.applicationType = applicationType;
            return (B)this.self();
        }

        public B gatewayServerUri(String gatewayServerUri) {
            this.gatewayServerUri = gatewayServerUri;
            return (B)this.self();
        }

        public B discoveryProfileUri(String discoveryProfileUri) {
            this.discoveryProfileUri = discoveryProfileUri;
            return (B)this.self();
        }

        public B discoveryUrls(String[] discoveryUrls) {
            this.discoveryUrls = discoveryUrls;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ApplicationDescription.ApplicationDescriptionBuilder(super=" + super.toString() + ", applicationUri=" + this.applicationUri + ", productUri=" + this.productUri + ", applicationName=" + this.applicationName + ", applicationType=" + this.applicationType + ", gatewayServerUri=" + this.gatewayServerUri + ", discoveryProfileUri=" + this.discoveryProfileUri + ", discoveryUrls=" + Arrays.deepToString(this.discoveryUrls) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ApplicationDescription> {
        @Override
        public Class<ApplicationDescription> getType() {
            return ApplicationDescription.class;
        }

        @Override
        public ApplicationDescription decode(SerializationContext context, UaDecoder decoder) {
            String applicationUri = decoder.readString("ApplicationUri");
            String productUri = decoder.readString("ProductUri");
            LocalizedText applicationName = decoder.readLocalizedText("ApplicationName");
            ApplicationType applicationType = decoder.readEnum("ApplicationType", ApplicationType.class);
            String gatewayServerUri = decoder.readString("GatewayServerUri");
            String discoveryProfileUri = decoder.readString("DiscoveryProfileUri");
            String[] discoveryUrls = decoder.readStringArray("DiscoveryUrls");
            return new ApplicationDescription(applicationUri, productUri, applicationName, applicationType, gatewayServerUri, discoveryProfileUri, discoveryUrls);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ApplicationDescription value) {
            encoder.writeString("ApplicationUri", value.getApplicationUri());
            encoder.writeString("ProductUri", value.getProductUri());
            encoder.writeLocalizedText("ApplicationName", value.getApplicationName());
            encoder.writeEnum("ApplicationType", value.getApplicationType());
            encoder.writeString("GatewayServerUri", value.getGatewayServerUri());
            encoder.writeString("DiscoveryProfileUri", value.getDiscoveryProfileUri());
            encoder.writeStringArray("DiscoveryUrls", value.getDiscoveryUrls());
        }
    }
}

