/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.netflix.servo.monitor.AbstractMonitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.util.Throwables;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

class AnnotatedStringMonitor
extends AbstractMonitor<String> {
    private final Object object;
    private final AccessibleObject field;

    AnnotatedStringMonitor(MonitorConfig config, Object object, AccessibleObject field) {
        super(config);
        this.object = object;
        this.field = field;
    }

    @Override
    public String getValue(int pollerIndex) {
        Object v;
        try {
            this.field.setAccessible(true);
            v = this.field instanceof Field ? ((Field)this.field).get(this.object) : ((Method)this.field).invoke(this.object, new Object[0]);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        return v == null ? null : v.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AnnotatedStringMonitor)) {
            return false;
        }
        AnnotatedStringMonitor m = (AnnotatedStringMonitor)obj;
        return this.config.equals(m.getConfig()) && this.field.equals(m.field);
    }

    public int hashCode() {
        int result = this.config.hashCode();
        result = 31 * result + this.field.hashCode();
        return result;
    }

    public String toString() {
        return "AnnotatedStringMonitor{config=" + this.config + ", field=" + this.field + '}';
    }
}

