/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.exception;

import java.util.Objects;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.core.exception.TransactionException;
import org.apache.seata.core.exception.TransactionExceptionCode;
import org.apache.seata.core.model.LockStatus;
import org.apache.seata.core.protocol.AbstractResultMessage;
import org.apache.seata.core.protocol.ResultCode;
import org.apache.seata.core.protocol.transaction.AbstractTransactionRequest;
import org.apache.seata.core.protocol.transaction.AbstractTransactionResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExceptionHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExceptionHandler.class);
    protected static final Configuration CONFIG = ConfigurationFactory.getInstance();

    public <T extends AbstractTransactionRequest, S extends AbstractTransactionResponse> void exceptionHandleTemplate(Callback<T, S> callback, T request, S response) {
        try {
            callback.execute(request, response);
            callback.onSuccess(request, response);
        }
        catch (TransactionException tex) {
            if (Objects.equals((Object)TransactionExceptionCode.LockKeyConflict, (Object)tex.getCode())) {
                LOGGER.error("this request cannot acquire global lock, you can let Seata retry by setting config [{}] = false or manually retry by yourself. request: {}", (Object)"client.rm.lock.retryPolicyBranchRollbackOnConflict", request);
            } else if (Objects.equals((Object)TransactionExceptionCode.LockKeyConflictFailFast, (Object)tex.getCode())) {
                LOGGER.error("this request cannot acquire global lock, decide fail-fast because LockStatus is {}. request: {}", (Object)LockStatus.Rollbacking, request);
            } else {
                LOGGER.error("Catch TransactionException while do RPC, request: {}", request, (Object)tex);
            }
            callback.onTransactionException(request, response, tex);
        }
        catch (RuntimeException rex) {
            LOGGER.error("Catch RuntimeException while do RPC, request: {}", request, (Object)rex);
            callback.onException(request, response, rex);
        }
    }

    public static interface Callback<T extends AbstractTransactionRequest, S extends AbstractTransactionResponse> {
        public void execute(T var1, S var2) throws TransactionException;

        public void onSuccess(T var1, S var2);

        public void onTransactionException(T var1, S var2, TransactionException var3);

        public void onException(T var1, S var2, Exception var3);
    }

    public static abstract class AbstractCallback<T extends AbstractTransactionRequest, S extends AbstractTransactionResponse>
    implements Callback<T, S> {
        @Override
        public void onSuccess(T request, S response) {
            ((AbstractResultMessage)response).setResultCode(ResultCode.Success);
        }

        @Override
        public void onTransactionException(T request, S response, TransactionException tex) {
            ((AbstractTransactionResponse)response).setTransactionExceptionCode(tex.getCode());
            ((AbstractResultMessage)response).setResultCode(ResultCode.Failed);
            ((AbstractResultMessage)response).setMsg("TransactionException[" + tex.getMessage() + "]");
        }

        @Override
        public void onException(T request, S response, Exception rex) {
            ((AbstractResultMessage)response).setResultCode(ResultCode.Failed);
            ((AbstractResultMessage)response).setMsg("RuntimeException[" + rex.getMessage() + "]");
        }
    }
}

