/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.rocksdb;

import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.util.Optional;
import org.apache.bifromq.basekv.localengine.AbstractKVSpaceReader;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.localengine.rocksdb.IRocksDBKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.rocksdb.Keys;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBHelper;
import org.apache.bifromq.basekv.localengine.rocksdb.RocksDBSnapshot;
import org.apache.bifromq.basekv.proto.Boundary;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;

abstract class AbstractRocksDBKVSpaceReader
extends AbstractKVSpaceReader {
    protected AbstractRocksDBKVSpaceReader(String id, KVSpaceOpMeters opMeters, Logger logger) {
        super(id, opMeters, logger);
    }

    protected abstract IRocksDBKVSpaceEpoch handle();

    protected abstract RocksDBSnapshot snapshot();

    protected final long doSize(Boundary boundary) {
        return RocksDBHelper.sizeOfBoundary(this.handle(), boundary);
    }

    protected final boolean doExist(ByteString key) {
        return this.get(key).isPresent();
    }

    protected final Optional<ByteString> doGet(ByteString key) {
        Optional<ByteString> optional;
        ReadOptions readOptions = new ReadOptions();
        try {
            readOptions.setSnapshot(this.snapshot().snapshot());
            IRocksDBKVSpaceEpoch dbHandle = this.handle();
            byte[] data = dbHandle.db().get(dbHandle.cf(), readOptions, Keys.toDataKey(key));
            optional = Optional.ofNullable(data == null ? null : UnsafeByteOperations.unsafeWrap((byte[])data));
        }
        catch (Throwable throwable) {
            try {
                try {
                    readOptions.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (RocksDBException rocksDBException) {
                throw new KVEngineException("Get failed", (Throwable)rocksDBException);
            }
        }
        readOptions.close();
        return optional;
    }
}

