/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import jakarta.inject.Singleton;
import lombok.Generated;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.mqtt.inbox.IMqttBrokerClient;
import org.apache.bifromq.plugin.authprovider.AuthProviderManager;
import org.apache.bifromq.plugin.clientbalancer.ClientBalancerManager;
import org.apache.bifromq.plugin.eventcollector.EventCollectorManager;
import org.apache.bifromq.plugin.eventcollector.IEventCollector;
import org.apache.bifromq.plugin.manager.BifroMQPluginManager;
import org.apache.bifromq.plugin.resourcethrottler.ResourceThrottlerManager;
import org.apache.bifromq.plugin.settingprovider.ISettingProvider;
import org.apache.bifromq.plugin.settingprovider.SettingProviderManager;
import org.apache.bifromq.plugin.subbroker.ISubBroker;
import org.apache.bifromq.plugin.subbroker.ISubBrokerManager;
import org.apache.bifromq.plugin.subbroker.SubBrokerManager;
import org.apache.bifromq.starter.config.StandaloneConfig;
import org.apache.bifromq.starter.module.SharedResourceProvider;
import org.apache.bifromq.starter.module.SharedResourcesHolder;
import org.pf4j.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginModule
extends AbstractModule {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginModule.class);

    protected void configure() {
        this.bind(PluginManager.class).toProvider(PluginManagerProvider.class).in(Singleton.class);
        this.bind(ISubBrokerManager.class).toProvider(SubBrokerManagerProvider.class).in(Singleton.class);
        this.bind(AuthProviderManager.class).toProvider(AuthProviderManagerProvider.class).in(Singleton.class);
        this.bind(EventCollectorManager.class).toProvider(EventCollectorManagerProvider.class).in(Singleton.class);
        this.bind(ResourceThrottlerManager.class).toProvider(ResourceThrottlerManagerProvider.class).in(Singleton.class);
        this.bind(SettingProviderManager.class).toProvider(SettingProviderManagerProvider.class).in(Singleton.class);
        this.bind(ClientBalancerManager.class).toProvider(ClientBalancerManagerProvider.class).in(Singleton.class);
    }

    private static class PluginManagerProvider
    extends SharedResourceProvider<BifroMQPluginManager> {
        @Inject
        private PluginManagerProvider(SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
        }

        @Override
        public BifroMQPluginManager share() {
            BifroMQPluginManager pluginMgr = new BifroMQPluginManager();
            pluginMgr.getPlugins().forEach(plugin -> log.info("Loaded plugin: {}@{}", (Object)plugin.getDescriptor().getPluginId(), (Object)plugin.getDescriptor().getVersion()));
            return pluginMgr;
        }
    }

    private static class SubBrokerManagerProvider
    extends SharedResourceProvider<ISubBrokerManager> {
        private final PluginManager pluginManager;
        private final IMqttBrokerClient mqttBrokerClient;
        private final IInboxClient inboxClient;

        @Inject
        private SubBrokerManagerProvider(PluginManager pluginManager, IMqttBrokerClient mqttBrokerClient, IInboxClient inboxClient, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.pluginManager = pluginManager;
            this.mqttBrokerClient = mqttBrokerClient;
            this.inboxClient = inboxClient;
        }

        @Override
        public ISubBrokerManager share() {
            return new SubBrokerManager(this.pluginManager, new ISubBroker[]{this.mqttBrokerClient, this.inboxClient});
        }
    }

    private static class AuthProviderManagerProvider
    extends SharedResourceProvider<AuthProviderManager> {
        private final StandaloneConfig config;
        private final PluginManager pluginManager;
        private final SettingProviderManager settingProviderManager;
        private final EventCollectorManager eventCollectorManager;

        @Inject
        private AuthProviderManagerProvider(StandaloneConfig config, PluginManager pluginManager, SettingProviderManager settingProviderManager, EventCollectorManager eventCollectorManager, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.pluginManager = pluginManager;
            this.settingProviderManager = settingProviderManager;
            this.eventCollectorManager = eventCollectorManager;
        }

        @Override
        public AuthProviderManager share() {
            return new AuthProviderManager(this.config.getAuthProviderFQN(), this.pluginManager, (ISettingProvider)this.settingProviderManager, (IEventCollector)this.eventCollectorManager);
        }
    }

    private static class EventCollectorManagerProvider
    extends SharedResourceProvider<EventCollectorManager> {
        private final PluginManager pluginManager;

        @Inject
        private EventCollectorManagerProvider(PluginManager pluginManager, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.pluginManager = pluginManager;
        }

        @Override
        public EventCollectorManager share() {
            return new EventCollectorManager(this.pluginManager);
        }
    }

    private static class ResourceThrottlerManagerProvider
    extends SharedResourceProvider<ResourceThrottlerManager> {
        private final StandaloneConfig config;
        private final PluginManager pluginManager;

        @Inject
        private ResourceThrottlerManagerProvider(StandaloneConfig config, PluginManager pluginManager, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.pluginManager = pluginManager;
        }

        @Override
        public ResourceThrottlerManager share() {
            return new ResourceThrottlerManager(this.config.getResourceThrottlerFQN(), this.pluginManager);
        }
    }

    private static class SettingProviderManagerProvider
    extends SharedResourceProvider<SettingProviderManager> {
        private final StandaloneConfig config;
        private final PluginManager pluginManager;

        @Inject
        private SettingProviderManagerProvider(StandaloneConfig config, PluginManager pluginManager, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.config = config;
            this.pluginManager = pluginManager;
        }

        @Override
        public SettingProviderManager share() {
            return new SettingProviderManager(this.config.getSettingProviderFQN(), this.pluginManager);
        }
    }

    private static class ClientBalancerManagerProvider
    extends SharedResourceProvider<ClientBalancerManager> {
        private final PluginManager pluginManager;

        @Inject
        private ClientBalancerManagerProvider(PluginManager pluginManager, SharedResourcesHolder sharedResourcesHolder) {
            super(sharedResourcesHolder);
            this.pluginManager = pluginManager;
        }

        @Override
        public ClientBalancerManager share() {
            return new ClientBalancerManager(this.pluginManager);
        }
    }
}

