/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import org.apache.hugegraph.computer.core.common.exception.TransportException;
import org.apache.hugegraph.computer.core.network.ClientHandler;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.network.message.AckMessage;
import org.apache.hugegraph.computer.core.network.message.DataMessage;
import org.apache.hugegraph.computer.core.network.message.FinishMessage;
import org.apache.hugegraph.computer.core.network.message.Message;
import org.apache.hugegraph.computer.core.network.message.StartMessage;
import org.apache.hugegraph.computer.core.network.netty.AbstractNettyHandler;
import org.apache.hugegraph.computer.core.network.netty.HeartbeatHandler;
import org.apache.hugegraph.computer.core.network.netty.NettyTransportClient;
import org.apache.hugegraph.computer.core.network.session.ClientSession;

public class NettyClientHandler
extends AbstractNettyHandler {
    private final NettyTransportClient client;

    public NettyClientHandler(NettyTransportClient client) {
        this.client = client;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        ctx.channel().attr(HeartbeatHandler.TIMEOUT_HEARTBEAT_COUNT).set((Object)0);
        super.channelRead0(ctx, msg);
    }

    @Override
    protected void processStartMessage(ChannelHandlerContext ctx, Channel channel, StartMessage startMessage) {
        throw new UnsupportedOperationException("Client does not support processStartMessage()");
    }

    @Override
    protected void processFinishMessage(ChannelHandlerContext ctx, Channel channel, FinishMessage finishMessage) {
        throw new UnsupportedOperationException("Client does not support processFinishMessage()");
    }

    @Override
    protected void processDataMessage(ChannelHandlerContext ctx, Channel channel, DataMessage dataMessage) {
        throw new UnsupportedOperationException("Client does not support processDataMessage()");
    }

    @Override
    protected void processAckMessage(ChannelHandlerContext ctx, Channel channel, AckMessage ackMessage) {
        int ackId = ackMessage.ackId();
        assert (ackId > -1);
        this.session().onRecvAck(ackId);
        this.client.checkAndNotifySendAvailable();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.transportHandler().onChannelInactive(this.client.connectionId());
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        TransportException exception = cause instanceof TransportException ? (TransportException)cause : new TransportException("%s when the client receive data from '%s'", cause, cause.getMessage(), TransportUtil.remoteAddress(ctx.channel()));
        this.client.clientHandler().exceptionCaught(exception, this.client.connectionId());
    }

    @Override
    protected ClientSession session() {
        return this.client.clientSession();
    }

    @Override
    protected ClientHandler transportHandler() {
        return this.client.clientHandler();
    }
}

