/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.network.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.hugegraph.computer.core.network.TransportUtil;
import org.apache.hugegraph.computer.core.network.message.PingMessage;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@ChannelHandler.Sharable
public class HeartbeatHandler
extends ChannelDuplexHandler {
    private static final Logger LOG = Log.logger(HeartbeatHandler.class);
    public static final AttributeKey<Integer> TIMEOUT_HEARTBEAT_COUNT = AttributeKey.valueOf((String)"TIMEOUT_HEARTBEAT_COUNT");
    public static final AttributeKey<Integer> MAX_TIMEOUT_HEARTBEAT_COUNT = AttributeKey.valueOf((String)"MAX_TIMEOUT_HEARTBEAT_COUNT");

    public void userEventTriggered(ChannelHandlerContext ctx, Object event) throws Exception {
        if (event instanceof IdleStateEvent) {
            Channel channel = ctx.channel();
            Integer maxTimeoutCount = (Integer)channel.attr(MAX_TIMEOUT_HEARTBEAT_COUNT).get();
            assert (maxTimeoutCount != null);
            Integer lastTimeoutCount = (Integer)channel.attr(TIMEOUT_HEARTBEAT_COUNT).get();
            assert (lastTimeoutCount != null);
            int timeoutHeartbeatCount = lastTimeoutCount + 1;
            if (timeoutHeartbeatCount > maxTimeoutCount) {
                LOG.info("The number of timeouts for waiting heartbeat response more than the max_timeout_heartbeat_count, close connection to '{}' from client side, count: {}", (Object)TransportUtil.remoteAddress(channel), (Object)timeoutHeartbeatCount);
                ctx.close();
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Client IdleStateEvent trigger to send ping to '{}', count: {}", (Object)TransportUtil.remoteAddress(channel), (Object)timeoutHeartbeatCount);
                }
                ctx.writeAndFlush((Object)PingMessage.INSTANCE).addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
                channel.attr(TIMEOUT_HEARTBEAT_COUNT).set((Object)timeoutHeartbeatCount);
            }
        } else {
            super.userEventTriggered(ctx, event);
        }
    }
}

