/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.NumericUtil;

public final class LongEncoding {
    private static final String B64_SYMBOLS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~";
    private static final String LENGTH_SYMBOLS = "0123456789ABCDEF";
    private static final char SORTABLE_NEG = "0123456789ABCDEF".charAt(0);
    private static final char SIGNED_NEG = '-';
    private static final long FULL_LONG = Long.MIN_VALUE;

    public static String encodeNumber(Object number) {
        Number num = NumericUtil.convertToNumber(number);
        long value = NumericUtil.numberToSortableLong(num);
        return LongEncoding.encodeSortable(value);
    }

    public static Number decodeNumber(String str, Class<?> clazz) {
        long value = LongEncoding.decodeSortable(str);
        return NumericUtil.sortableLongToNumber(value, clazz);
    }

    public static String encodeSortable(long num) {
        String encoded;
        int length;
        boolean negative = false;
        if (num < 0L) {
            negative = true;
            num += Long.MIN_VALUE;
        }
        E.checkArgument((length = (encoded = LongEncoding.encode(num, B64_SYMBOLS)).length()) <= LENGTH_SYMBOLS.length(), "Length symbols can't represent encoded number '%s'", encoded);
        StringBuilder sb = new StringBuilder(length + 2);
        if (negative) {
            sb.append(SORTABLE_NEG);
        }
        char len = LENGTH_SYMBOLS.charAt(length);
        sb.append(len);
        sb.append(encoded);
        return sb.toString();
    }

    public static long decodeSortable(String str) {
        int length;
        E.checkArgument(str.length() >= 2, "Length of sortable encoded string must be >=2", new Object[0]);
        boolean negative = str.charAt(0) == SORTABLE_NEG;
        int lengthPos = 0;
        if (negative) {
            lengthPos = 1;
        }
        E.checkArgument((length = B64_SYMBOLS.indexOf(str.charAt(lengthPos))) == str.length() - lengthPos - 1, "Can't decode illegal string '%s' with wrong length", str);
        String encoded = str.substring(lengthPos + 1);
        long value = LongEncoding.decode(encoded, B64_SYMBOLS);
        if (negative) {
            value -= Long.MIN_VALUE;
        }
        return value;
    }

    public static String encodeSignedB64(long value) {
        boolean negative = false;
        if (value < 0L) {
            negative = true;
            if (value == Long.MIN_VALUE) {
                return "-80000000000";
            }
            value = -value;
        }
        assert (value >= 0L) : value;
        String encoded = LongEncoding.encodeB64(value);
        return negative ? '-' + encoded : encoded;
    }

    public static long decodeSignedB64(String value) {
        boolean negative = false;
        if (!value.isEmpty() && value.charAt(0) == '-') {
            negative = true;
            value = value.substring(1);
        }
        long decoded = LongEncoding.decodeB64(value);
        return negative ? -decoded : decoded;
    }

    public static boolean validB64Char(char c) {
        return B64_SYMBOLS.indexOf(c) != -1;
    }

    public static String encodeB64(long num) {
        return LongEncoding.encode(num, B64_SYMBOLS);
    }

    public static long decodeB64(String str) {
        return LongEncoding.decode(str, B64_SYMBOLS);
    }

    public static long decode(String encoded, String symbols) {
        int B = symbols.length();
        E.checkArgument(B > 0, "The symbols parameter can't be empty", new Object[0]);
        long num = 0L;
        for (char ch : encoded.toCharArray()) {
            num *= (long)B;
            int pos = symbols.indexOf(ch);
            if (pos < 0) {
                throw new NumberFormatException(String.format("Can't decode symbol '%s' in string '%s'", Character.valueOf(ch), encoded));
            }
            num += (long)pos;
        }
        return num;
    }

    public static String encode(long num, String symbols) {
        int B = symbols.length();
        E.checkArgument(num >= 0L, "Expected non-negative number: %s", num);
        E.checkArgument(B > 0, "The symbols parameter can't be empty", new Object[0]);
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(symbols.charAt((int)(num % (long)B)));
        } while ((num /= (long)B) != 0L);
        return sb.reverse().toString();
    }
}

