/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.operator.controller;

import com.google.common.base.Throwables;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ContainerState;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobCondition;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.utils.PodStatusUtil;
import io.fabric8.kubernetes.client.utils.Serialization;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hugegraph.computer.driver.JobStatus;
import org.apache.hugegraph.computer.k8s.crd.model.CommonComponentState;
import org.apache.hugegraph.computer.k8s.crd.model.ComponentState;
import org.apache.hugegraph.computer.k8s.crd.model.ComponentStateBuilder;
import org.apache.hugegraph.computer.k8s.crd.model.ComputerJobSpec;
import org.apache.hugegraph.computer.k8s.crd.model.ComputerJobStatus;
import org.apache.hugegraph.computer.k8s.crd.model.ComputerJobStatusBuilder;
import org.apache.hugegraph.computer.k8s.crd.model.EditableComponentState;
import org.apache.hugegraph.computer.k8s.crd.model.EventType;
import org.apache.hugegraph.computer.k8s.crd.model.HugeGraphComputerJob;
import org.apache.hugegraph.computer.k8s.crd.model.HugeGraphComputerJobList;
import org.apache.hugegraph.computer.k8s.crd.model.JobComponentState;
import org.apache.hugegraph.computer.k8s.crd.model.PodPhase;
import org.apache.hugegraph.computer.k8s.operator.common.AbstractController;
import org.apache.hugegraph.computer.k8s.operator.common.MatchWithMsg;
import org.apache.hugegraph.computer.k8s.operator.common.OperatorRequest;
import org.apache.hugegraph.computer.k8s.operator.common.OperatorResult;
import org.apache.hugegraph.computer.k8s.operator.config.OperatorOptions;
import org.apache.hugegraph.computer.k8s.operator.controller.ComputerJobComponent;
import org.apache.hugegraph.computer.k8s.operator.controller.ComputerJobDeployer;
import org.apache.hugegraph.computer.k8s.util.KubeUtil;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class ComputerJobController
extends AbstractController<HugeGraphComputerJob> {
    private static final Logger LOG = Log.logger(AbstractController.class);
    private final MixedOperation<HugeGraphComputerJob, HugeGraphComputerJobList, Resource<HugeGraphComputerJob>> operation;
    private final Boolean autoDestroyPod;
    private static final int TOTAL_COMPONENTS = 2;
    private static final int ALLOW_FAILED_JOBS = 0;
    private static final int ALLOW_FAILED_COMPONENTS = 0;
    private static final int ERROR_LOG_TAILING_LINES = 500;
    private static final String POD_REASON_UNSCHEDULABLE = "Unschedulable";
    private static final String IMAGE_PULL_BACKOFF = "ImagePullBackOff";
    private static final String CONDITION_STATUS_FALSE = "False";
    private static final String FINALIZER_NAME = CustomResource.getCRDName(HugeGraphComputerJob.class) + "/finalizers";

    public ComputerJobController(HugeConfig config, NamespacedKubernetesClient kubeClient) {
        super(config, kubeClient);
        this.operation = this.kubeClient.customResources(HugeGraphComputerJob.class, HugeGraphComputerJobList.class);
        this.autoDestroyPod = (Boolean)this.config.get(OperatorOptions.AUTO_DESTROY_POD);
    }

    @Override
    protected OperatorResult reconcile(OperatorRequest request) {
        HugeGraphComputerJob computerJob = (HugeGraphComputerJob)this.getCR(request);
        if (computerJob == null) {
            LOG.info("Unable to fetch HugeGraphComputerJob {}, it may have been deleted", (Object)request.name());
            return OperatorResult.NO_REQUEUE;
        }
        this.fillCRStatus(computerJob);
        if (this.finalizer(computerJob)) {
            return OperatorResult.NO_REQUEUE;
        }
        ComputerJobComponent observed = this.observeComponent(computerJob);
        if (!this.updateStatus(observed) && request.retryTimes() == 0) {
            LOG.debug("Wait status to be stable before taking further actions");
            return OperatorResult.NO_REQUEUE;
        }
        if (Objects.equals(((ComputerJobStatus)computerJob.getStatus()).getJobStatus(), JobStatus.RUNNING.name())) {
            String crName = computerJob.getMetadata().getName();
            LOG.info("ComputerJob {} already running, no action", (Object)crName);
            return OperatorResult.NO_REQUEUE;
        }
        ComputerJobDeployer deployer = new ComputerJobDeployer(this.kubeClient, this.config);
        deployer.deploy(observed);
        return OperatorResult.NO_REQUEUE;
    }

    @Override
    protected void handleFailOverLimit(OperatorRequest request, Exception e) {
        HugeGraphComputerJob computerJob = (HugeGraphComputerJob)this.getCR(request);
        if (computerJob == null) {
            LOG.info("Unable to fetch HugeGraphComputerJob {}, it may have been deleted", (Object)request.name());
            return;
        }
        String crName = computerJob.getMetadata().getName();
        LOG.warn("ComputerJob {} reconcile failed reach {} times", (Object)crName, (Object)request.retryTimes());
        this.recordEvent(computerJob, EventType.WARNING, KubeUtil.failedEventName(crName), String.format("ComputerJob %s reconcile failed\n", crName), Throwables.getStackTraceAsString(e));
        ((ComputerJobStatus)computerJob.getStatus()).setJobStatus(JobStatus.FAILED.name());
        this.updateStatus(computerJob);
    }

    @Override
    protected MatchWithMsg ownsPredicate(HasMetadata ownsResource) {
        String kind;
        Map<String, String> labels;
        String crName;
        ObjectMeta metadata;
        MatchWithMsg ownsMatch = super.ownsPredicate(ownsResource);
        if (ownsMatch.isMatch()) {
            return ownsMatch;
        }
        if (ownsResource instanceof Pod && (metadata = ownsResource.getMetadata()) != null && metadata.getLabels() != null && StringUtils.isNotBlank(crName = KubeUtil.matchKindAndGetCrName(labels = metadata.getLabels(), kind = HasMetadata.getKind(HugeGraphComputerJob.class)))) {
            return new MatchWithMsg(true, crName);
        }
        return MatchWithMsg.NO_MATCH;
    }

    private boolean finalizer(HugeGraphComputerJob computerJob) {
        if (computerJob.addFinalizer(FINALIZER_NAME)) {
            this.replaceCR(computerJob);
            return true;
        }
        ComputerJobStatus status = (ComputerJobStatus)computerJob.getStatus();
        if (computerJob.isMarkedForDeletion()) {
            if (!JobStatus.finished(status.getJobStatus())) {
                status.setJobStatus(JobStatus.CANCELLED.name());
                this.updateStatus(computerJob);
            } else if (computerJob.removeFinalizer(FINALIZER_NAME)) {
                this.replaceCR(computerJob);
            }
            return true;
        }
        if (JobStatus.finished(status.getJobStatus())) {
            if (this.autoDestroyPod.booleanValue()) {
                this.deleteCR(computerJob);
            }
            return true;
        }
        return false;
    }

    private boolean updateStatus(ComputerJobComponent observed) {
        ComputerJobStatus newStatus = this.derivedCRStatus(observed);
        ComputerJobStatus oldStatus = (ComputerJobStatus)observed.computerJob().getStatus();
        if (!Objects.deepEquals(oldStatus, newStatus)) {
            HugeGraphComputerJob computerJob = observed.computerJob();
            computerJob.setStatus(newStatus);
            this.updateStatus(computerJob);
            return true;
        }
        return false;
    }

    private ComputerJobStatus derivedCRStatus(ComputerJobComponent observed) {
        HugeGraphComputerJob computerJob = observed.computerJob();
        ComputerJobSpec spec = (ComputerJobSpec)computerJob.getSpec();
        MutableInt failedComponents = new MutableInt(0);
        MutableInt succeededComponents = new MutableInt(0);
        MutableInt runningComponents = new MutableInt(0);
        ComputerJobStatus status = Serialization.clone((ComputerJobStatus)computerJob.getStatus());
        ConfigMap configMap = observed.configMap();
        if (configMap != null) {
            EditableComponentState configMapState = ((ComponentStateBuilder)((ComponentStateBuilder)new ComponentStateBuilder().withName(configMap.getMetadata().getName())).withState(CommonComponentState.READY.value())).build();
            status.getComponentStates().setConfigMap(configMapState);
        } else if (status.getComponentStates().getConfigMap() != null) {
            status.getComponentStates().getConfigMap().setState(CommonComponentState.DELETED.value());
        }
        Job masterJob = observed.masterJob();
        ComponentState masterJobState = this.deriveJobStatus(masterJob, observed.masterPods(), status.getComponentStates().getMasterJob(), 1, failedComponents, succeededComponents, runningComponents);
        status.getComponentStates().setMasterJob(masterJobState);
        Job workerJob = observed.workerJob();
        ComponentState workerJobState = this.deriveJobStatus(workerJob, observed.workerPods(), status.getComponentStates().getWorkerJob(), spec.getWorkerInstances(), failedComponents, succeededComponents, runningComponents);
        status.getComponentStates().setWorkerJob(workerJobState);
        if (failedComponents.intValue() > 0) {
            status.setJobStatus(JobStatus.FAILED.name());
            this.recordFailedEvent(computerJob, masterJobState, workerJobState);
            return status;
        }
        if (succeededComponents.intValue() == 2) {
            status.setJobStatus(JobStatus.SUCCEEDED.name());
            String crName = computerJob.getMetadata().getName();
            long cost = this.calculateJobCost(computerJob);
            this.recordEvent(computerJob, EventType.NORMAL, KubeUtil.succeedEventName(crName), "ComputerJobSucceed", String.format("Job %s run successfully, took %ss", crName, cost));
            return status;
        }
        int activeComponents = runningComponents.intValue() + succeededComponents.intValue();
        if (activeComponents == 2) {
            status.setJobStatus(JobStatus.RUNNING.name());
        } else {
            status.setJobStatus(JobStatus.INITIALIZING.name());
        }
        return status;
    }

    private long calculateJobCost(HugeGraphComputerJob computerJob) {
        String creationTimestamp = computerJob.getMetadata().getCreationTimestamp();
        long createTime = OffsetDateTime.parse(creationTimestamp).toEpochSecond();
        long now = OffsetDateTime.now().toEpochSecond();
        return now - createTime;
    }

    private ComponentState deriveJobStatus(Job job, List<Pod> pods, ComponentState oldSate, int instances, MutableInt failedComponents, MutableInt succeededComponents, MutableInt runningComponents) {
        if (job != null && job.getStatus() != null) {
            ComponentState newState = new ComponentState();
            newState.setName(job.getMetadata().getName());
            int succeeded = KubeUtil.intVal(job.getStatus().getSucceeded());
            int failed = KubeUtil.intVal(job.getStatus().getFailed());
            MatchWithMsg unSchedulable = this.unSchedulable(pods);
            MatchWithMsg failedPullImage = this.imagePullBackOff(pods);
            if (succeeded >= instances) {
                newState.setState(JobComponentState.SUCCEEDED.name());
                succeededComponents.increment();
            } else if (failed > 0) {
                String errorLog;
                newState.setState(JobComponentState.FAILED.name());
                List<JobCondition> conditions = job.getStatus().getConditions();
                if (CollectionUtils.isNotEmpty(conditions)) {
                    newState.setMessage(conditions.get(0).getMessage());
                }
                if (StringUtils.isNotBlank(errorLog = this.getErrorLog(pods))) {
                    newState.setErrorLog(errorLog);
                }
                failedComponents.increment();
            } else if (unSchedulable.isMatch()) {
                newState.setState(JobStatus.FAILED.name());
                newState.setMessage(unSchedulable.msg());
                failedComponents.increment();
            } else if (failedPullImage.isMatch()) {
                newState.setState(JobStatus.FAILED.name());
                newState.setMessage(failedPullImage.msg());
                failedComponents.increment();
            } else {
                int running = pods.stream().filter(PodStatusUtil::isRunning).mapToInt(x -> 1).sum();
                int active = running + succeeded;
                if (active >= instances) {
                    newState.setState(JobComponentState.RUNNING.value());
                    runningComponents.increment();
                } else {
                    newState.setState(JobComponentState.PENDING.value());
                }
            }
            return newState;
        }
        if (oldSate != null) {
            oldSate.setState(JobComponentState.CANCELLED.value());
        }
        return oldSate;
    }

    private void fillCRStatus(HugeGraphComputerJob computerJob) {
        ComputerJobStatus status = computerJob.getStatus() == null ? new ComputerJobStatus() : (ComputerJobStatus)computerJob.getStatus();
        status = ((ComputerJobStatusBuilder)((ComputerJobStatusBuilder)new ComputerJobStatusBuilder(status).editOrNewComponentStates().endComponentStates()).editOrNewJobState().endJobState()).build();
        computerJob.setStatus(status);
    }

    private ComputerJobComponent observeComponent(HugeGraphComputerJob computerJob) {
        ComputerJobComponent observed = new ComputerJobComponent();
        observed.computerJob(computerJob);
        String namespace = computerJob.getMetadata().getNamespace();
        String crName = computerJob.getMetadata().getName();
        String masterName = KubeUtil.masterJobName(crName);
        Job master = this.getResourceByName(namespace, masterName, Job.class);
        observed.masterJob(master);
        if (master != null) {
            List<Pod> masterPods = this.getPodsByJob(master);
            observed.masterPods(masterPods);
        }
        String workerName = KubeUtil.workerJobName(crName);
        Job worker = this.getResourceByName(namespace, workerName, Job.class);
        observed.workerJob(worker);
        if (worker != null) {
            List<Pod> workerPods = this.getPodsByJob(worker);
            observed.workerPods(workerPods);
        }
        String configMapName = KubeUtil.configMapName(crName);
        ConfigMap configMap = this.getResourceByName(namespace, configMapName, ConfigMap.class);
        observed.configMap(configMap);
        return observed;
    }

    private void updateStatus(HugeGraphComputerJob computerJob) {
        ((ComputerJobStatus)computerJob.getStatus()).setLastUpdateTime(KubeUtil.now());
        String namespace = computerJob.getMetadata().getNamespace();
        if (Objects.equals(this.kubeClient.getNamespace(), namespace)) {
            this.operation.replaceStatus(computerJob);
        } else {
            ((NonNamespaceOperation)this.operation.inNamespace(namespace)).replaceStatus(computerJob);
        }
    }

    private void replaceCR(HugeGraphComputerJob computerJob) {
        ((ComputerJobStatus)computerJob.getStatus()).setLastUpdateTime(KubeUtil.now());
        String namespace = computerJob.getMetadata().getNamespace();
        if (Objects.equals(this.kubeClient.getNamespace(), namespace)) {
            this.operation.replace(computerJob);
        } else {
            ((NonNamespaceOperation)this.operation.inNamespace(namespace)).replace(computerJob);
        }
    }

    private void deleteCR(HugeGraphComputerJob computerJob) {
        String namespace = computerJob.getMetadata().getNamespace();
        if (Objects.equals(this.kubeClient.getNamespace(), namespace)) {
            this.operation.delete(computerJob);
        } else {
            ((NonNamespaceOperation)this.operation.inNamespace(namespace)).delete(computerJob);
        }
    }

    private MatchWithMsg unSchedulable(List<Pod> pods) {
        if (CollectionUtils.isEmpty(pods)) {
            return MatchWithMsg.NO_MATCH;
        }
        for (Pod pod : pods) {
            List<PodCondition> conditions = pod.getStatus().getConditions();
            for (PodCondition condition : conditions) {
                if (!Objects.equals(condition.getStatus(), CONDITION_STATUS_FALSE) || !Objects.equals(condition.getReason(), POD_REASON_UNSCHEDULABLE)) continue;
                return new MatchWithMsg(true, condition.getReason() + ", " + condition.getMessage());
            }
        }
        return MatchWithMsg.NO_MATCH;
    }

    private MatchWithMsg imagePullBackOff(List<Pod> pods) {
        if (CollectionUtils.isEmpty(pods)) {
            return MatchWithMsg.NO_MATCH;
        }
        for (Pod pod : pods) {
            List<ContainerStatus> containerStatus = PodStatusUtil.getContainerStatus(pod);
            if (!CollectionUtils.isNotEmpty(containerStatus)) continue;
            for (ContainerStatus status : containerStatus) {
                ContainerStateWaiting waiting;
                ContainerState state = status.getState();
                if (state == null || (waiting = state.getWaiting()) == null || !IMAGE_PULL_BACKOFF.equals(waiting.getReason())) continue;
                return new MatchWithMsg(true, waiting.getReason() + ", " + waiting.getMessage());
            }
        }
        return MatchWithMsg.NO_MATCH;
    }

    private void recordFailedEvent(HugeGraphComputerJob computerJob, ComponentState masterJobState, ComponentState workerJobState) {
        String workerErrorLog;
        String workerFailedMsg;
        String masterErrorLog;
        StringBuilder builder = new StringBuilder();
        String masterFailedMsg = masterJobState.getMessage();
        if (StringUtils.isNotBlank(masterFailedMsg)) {
            builder.append("master failed message: \n");
            builder.append(masterFailedMsg);
        }
        if (StringUtils.isNotBlank(masterErrorLog = masterJobState.getErrorLog())) {
            builder.append("\n");
            builder.append("master error log: \n");
            builder.append(masterErrorLog);
        }
        if (StringUtils.isNotBlank(workerFailedMsg = workerJobState.getMessage())) {
            builder.append("\n");
            builder.append("worker failed message: \n");
            builder.append(workerFailedMsg);
        }
        if (StringUtils.isNotBlank(workerErrorLog = workerJobState.getErrorLog())) {
            builder.append("\n");
            builder.append("worker error log: \n");
            builder.append(workerErrorLog);
        }
        String crName = computerJob.getMetadata().getName();
        this.recordEvent(computerJob, EventType.WARNING, KubeUtil.failedEventName(crName), "ComputerJobFailed", builder.toString());
    }

    private String getErrorLog(List<Pod> pods) {
        for (Pod pod : pods) {
            String log;
            String namespace = pod.getMetadata().getNamespace();
            String name = pod.getMetadata().getName();
            if (pod.getStatus() == null || !PodPhase.FAILED.value().equals(pod.getStatus().getPhase())) continue;
            KubernetesClient client = this.kubeClient;
            if (!Objects.equals(this.kubeClient.getNamespace(), namespace)) {
                client = (KubernetesClient)this.kubeClient.inNamespace(namespace);
            }
            try {
                log = ((PrettyLoggable)((PodResource)client.pods().withName(name)).tailingLines(500)).getLog(true);
            }
            catch (KubernetesClientException e) {
                if (e.getCode() == 404) continue;
                throw e;
            }
            if (!StringUtils.isNotBlank(log) || log.contains("Unable to retrieve container logs")) continue;
            return log + "\n podName:" + pod.getMetadata().getName() + "\n nodeIp:" + pod.getStatus().getHostIP();
        }
        return "";
    }
}

