/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.config;

import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.config.HotConfig;
import org.apache.hugegraph.computer.core.config.Null;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.E;

public final class DefaultConfig
implements Config {
    private final HugeConfig allConfig;
    private final HotConfig hotConfig;

    public DefaultConfig(Map<String, String> options) {
        this.allConfig = this.parseOptions(options);
        this.hotConfig = this.extractHotConfig(this.allConfig);
        this.checkOptions();
    }

    private HugeConfig parseOptions(Map<String, String> options) {
        if (!options.keySet().containsAll(ComputerOptions.REQUIRED_OPTIONS)) {
            E.checkArgument((boolean)false, (String)"All required options must be setted, but missing these %s", (Object[])new Object[]{CollectionUtils.subtract(ComputerOptions.REQUIRED_OPTIONS, options.keySet())});
        }
        MapConfiguration mapConfig = new MapConfiguration(options);
        return new HugeConfig((Configuration)mapConfig);
    }

    private HotConfig extractHotConfig(HugeConfig allConfig) {
        HotConfig hotConfig = new HotConfig();
        hotConfig.outputVertexAdjacentEdges((Boolean)allConfig.get(ComputerOptions.OUTPUT_WITH_ADJACENT_EDGES));
        hotConfig.outputVertexProperties((Boolean)allConfig.get(ComputerOptions.OUTPUT_WITH_VERTEX_PROPERTIES));
        hotConfig.outputEdgeProperties((Boolean)allConfig.get(ComputerOptions.OUTPUT_WITH_EDGE_PROPERTIES));
        return hotConfig;
    }

    private void checkOptions() {
        int workersCount;
        int partitionsCount = (Integer)this.allConfig.get(ComputerOptions.JOB_PARTITIONS_COUNT);
        if (partitionsCount < (workersCount = ((Integer)this.allConfig.get(ComputerOptions.JOB_WORKERS_COUNT)).intValue())) {
            throw new ComputerException("The partitions count must be >= workers count, but got %s < %s", partitionsCount, workersCount);
        }
    }

    @Override
    public HugeConfig hugeConfig() {
        return this.allConfig;
    }

    @Override
    public <R> R get(TypedOption<?, R> option) {
        return (R)this.allConfig.get(option);
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.allConfig.getString(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ComputerException("Can't parse boolean value from '%s' for key '%s'", value, key);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        String value = this.allConfig.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ComputerException("Can't parse int value from '%s' for key '%s'", value, key);
        }
    }

    @Override
    public long getLong(String key, long defaultValue) {
        String value = this.allConfig.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            throw new ComputerException("Can't parse long value from '%s' for key '%s'", value, key);
        }
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        String value = this.allConfig.getString(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new ComputerException("Can't parse double value from '%s' for key '%s'", value, key);
        }
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.allConfig.getString(key, defaultValue);
    }

    @Override
    public <T> T createObject(ConfigOption<Class<?>> clazzOption) {
        return this.createObject(clazzOption, true);
    }

    @Override
    public <T> T createObject(ConfigOption<Class<?>> clazzOption, boolean requiredNotNull) {
        Class clazz = (Class)this.get((TypedOption)clazzOption);
        if (clazz == Null.class) {
            if (requiredNotNull) {
                throw new ComputerException("Please config required option '%s'", clazzOption.name());
            }
            return null;
        }
        try {
            Object instance = clazz.newInstance();
            return instance;
        }
        catch (Exception e) {
            throw new ComputerException("Failed to create object for option '%s', class='%s'", (Throwable)e, clazzOption.name(), clazz.getName());
        }
    }

    @Override
    public Boolean outputVertexAdjacentEdges() {
        return this.hotConfig.outputVertexAdjacentEdges();
    }

    @Override
    public Boolean outputVertexProperties() {
        return this.hotConfig.outputVertexProperties();
    }

    @Override
    public Boolean outputEdgeProperties() {
        return this.hotConfig.outputEdgeProperties();
    }
}

