/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.observable;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BooleanSupplier;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableRepeatUntil<T>
extends AbstractObservableWithUpstream<T, T> {
    final BooleanSupplier until;

    public ObservableRepeatUntil(Observable<T> source, BooleanSupplier until) {
        super(source);
        this.until = until;
    }

    @Override
    public void subscribeActual(Observer<? super T> observer) {
        SequentialDisposable sd = new SequentialDisposable();
        observer.onSubscribe(sd);
        RepeatUntilObserver<T> rs = new RepeatUntilObserver<T>(observer, this.until, sd, this.source);
        rs.subscribeNext();
    }

    static final class RepeatUntilObserver<T>
    extends AtomicInteger
    implements Observer<T> {
        private static final long serialVersionUID = -7098360935104053232L;
        final Observer<? super T> downstream;
        final SequentialDisposable upstream;
        final ObservableSource<? extends T> source;
        final BooleanSupplier stop;

        RepeatUntilObserver(Observer<? super T> actual, BooleanSupplier until, SequentialDisposable sd, ObservableSource<? extends T> source) {
            this.downstream = actual;
            this.upstream = sd;
            this.source = source;
            this.stop = until;
        }

        @Override
        public void onSubscribe(Disposable d) {
            this.upstream.replace(d);
        }

        @Override
        public void onNext(T t) {
            this.downstream.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            boolean b;
            try {
                b = this.stop.getAsBoolean();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.downstream.onError(e);
                return;
            }
            if (b) {
                this.downstream.onComplete();
            } else {
                this.subscribeNext();
            }
        }

        void subscribeNext() {
            block1: {
                if (this.getAndIncrement() != 0) break block1;
                int missed = 1;
                do {
                    this.source.subscribe(this);
                } while ((missed = this.addAndGet(-missed)) != 0);
            }
        }
    }
}

