/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.serialize;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.lettuce.core.codec.RedisCodec;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.hertzbeat.common.entity.log.LogEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLogEntryCodec
implements RedisCodec<String, LogEntry> {
    private static final Logger log = LoggerFactory.getLogger(RedisLogEntryCodec.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public String decodeKey(ByteBuffer byteBuffer) {
        return Unpooled.wrappedBuffer((ByteBuffer)byteBuffer).toString(StandardCharsets.UTF_8);
    }

    public LogEntry decodeValue(ByteBuffer byteBuffer) {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        try {
            String jsonString = Unpooled.wrappedBuffer((ByteBuffer)byteBuffer).toString(StandardCharsets.UTF_8);
            return (LogEntry)this.objectMapper.readValue(jsonString, LogEntry.class);
        }
        catch (Exception e) {
            log.error("Failed to decode LogEntry from JSON: {}", (Object)e.getMessage());
            return null;
        }
    }

    public ByteBuffer encodeKey(String s) {
        return ByteBuffer.wrap(s.getBytes(StandardCharsets.UTF_8));
    }

    public ByteBuffer encodeValue(LogEntry logEntry) {
        try {
            String jsonString = this.objectMapper.writeValueAsString((Object)logEntry);
            return ByteBuffer.wrap(jsonString.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error("Failed to encode LogEntry to JSON: {}", (Object)e.getMessage());
            return null;
        }
    }
}

