/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.types;

import java.util.HashMap;
import java.util.Map;

public enum PlcResponseCode {
    OK(1),
    NOT_FOUND(2),
    ACCESS_DENIED(3),
    INVALID_ADDRESS(4),
    INVALID_DATATYPE(6),
    INVALID_DATA(7),
    INTERNAL_ERROR(8),
    REMOTE_BUSY(9),
    REMOTE_ERROR(10),
    UNSUPPORTED(11),
    RESPONSE_PENDING(12);

    private static final Map<Short, PlcResponseCode> map;
    private final short value;

    static {
        map = new HashMap<Short, PlcResponseCode>();
        PlcResponseCode[] plcResponseCodeArray = PlcResponseCode.values();
        int n = plcResponseCodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlcResponseCode value = plcResponseCodeArray[n2];
            map.put(value.getValue(), value);
            ++n2;
        }
    }

    private PlcResponseCode(short value) {
        this.value = value;
    }

    public short getValue() {
        return this.value;
    }

    public static PlcResponseCode enumForValue(short value) {
        return map.get(value);
    }

    public static Boolean isDefined(short value) {
        return map.containsKey(value);
    }
}

