/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.walk;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.Error;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.Schema;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import com.networknt.schema.walk.ApplyDefaultsStrategy;
import com.networknt.schema.walk.WalkHandler;
import java.util.List;
import java.util.function.Consumer;

public class WalkConfig {
    private final ApplyDefaultsStrategy applyDefaultsStrategy;
    private final WalkHandler itemWalkHandler;
    private final WalkHandler keywordWalkHandler;
    private final WalkHandler propertyWalkHandler;

    public static WalkConfig getInstance() {
        return Holder.INSTANCE;
    }

    WalkConfig(ApplyDefaultsStrategy applyDefaultsStrategy, WalkHandler itemWalkHandler, WalkHandler keywordWalkHandler, WalkHandler propertyWalkHandler) {
        this.applyDefaultsStrategy = applyDefaultsStrategy;
        this.itemWalkHandler = itemWalkHandler;
        this.keywordWalkHandler = keywordWalkHandler;
        this.propertyWalkHandler = propertyWalkHandler;
    }

    public ApplyDefaultsStrategy getApplyDefaultsStrategy() {
        return this.applyDefaultsStrategy;
    }

    public WalkHandler getPropertyWalkHandler() {
        return this.propertyWalkHandler;
    }

    public WalkHandler getItemWalkHandler() {
        return this.itemWalkHandler;
    }

    public WalkHandler getKeywordWalkHandler() {
        return this.keywordWalkHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(WalkConfig config) {
        Builder builder = new Builder();
        builder.applyDefaultsStrategy = config.applyDefaultsStrategy;
        builder.itemWalkHandler = config.itemWalkHandler;
        builder.keywordWalkHandler = config.keywordWalkHandler;
        builder.propertyWalkHandler = config.propertyWalkHandler;
        return builder;
    }

    private static class Holder {
        private static final WalkConfig INSTANCE = WalkConfig.builder().build();

        private Holder() {
        }
    }

    public static class Builder {
        private ApplyDefaultsStrategy applyDefaultsStrategy = null;
        private WalkHandler itemWalkHandler = null;
        private WalkHandler keywordWalkHandler = null;
        private WalkHandler propertyWalkHandler = null;

        public Builder applyDefaultsStrategy(ApplyDefaultsStrategy applyDefaultsStrategy) {
            this.applyDefaultsStrategy = applyDefaultsStrategy;
            return this;
        }

        public Builder applyDefaultsStrategy(Consumer<ApplyDefaultsStrategy.Builder> customizer) {
            ApplyDefaultsStrategy.Builder builder = ApplyDefaultsStrategy.builder(this.applyDefaultsStrategy);
            customizer.accept(builder);
            return this.applyDefaultsStrategy(builder.build());
        }

        public Builder itemWalkHandler(WalkHandler itemWalkHandler) {
            this.itemWalkHandler = itemWalkHandler;
            return this;
        }

        public Builder keywordWalkHandler(WalkHandler keywordWalkHandler) {
            this.keywordWalkHandler = keywordWalkHandler;
            return this;
        }

        public Builder propertyWalkHandler(WalkHandler propertyWalkHandler) {
            this.propertyWalkHandler = propertyWalkHandler;
            return this;
        }

        public WalkConfig build() {
            return new WalkConfig(this.applyDefaultsStrategy != null ? this.applyDefaultsStrategy : ApplyDefaultsStrategy.EMPTY_APPLY_DEFAULTS_STRATEGY, this.itemWalkHandler != null ? this.itemWalkHandler : NoOpWalkHandler.getInstance(), this.keywordWalkHandler != null ? this.keywordWalkHandler : NoOpWalkHandler.getInstance(), this.propertyWalkHandler != null ? this.propertyWalkHandler : NoOpWalkHandler.getInstance());
        }
    }

    public static class NoOpWalkHandler
    implements WalkHandler {
        public static NoOpWalkHandler getInstance() {
            return Holder.INSTANCE;
        }

        @Override
        public boolean preWalk(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, NodePath instanceLocation, Schema schema, KeywordValidator validator) {
            return true;
        }

        @Override
        public void postWalk(ExecutionContext executionContext, String keyword, JsonNode instanceNode, JsonNode rootNode, NodePath instanceLocation, Schema schema, KeywordValidator validator, List<Error> errors) {
        }

        private static class Holder {
            private static final NoOpWalkHandler INSTANCE = new NoOpWalkHandler();

            private Holder() {
            }
        }
    }
}

