/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snmp4j.smi.OctetString;

public class ArgumentParser {
    public static final String[] TYPES = new String[]{"i", "l", "s", "o"};
    public static final int TYPE_INTEGER = 0;
    public static final int TYPE_LONG = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_OCTET_STRING = 3;
    private Map<String, ArgumentFormat> optionFormat;
    private Map<? extends String, ? extends ArgumentFormat> parameterFormat;

    public ArgumentParser(String optionFormat, String parameterFormat) {
        this.optionFormat = ArgumentParser.parseFormat(optionFormat, false);
        this.parameterFormat = ArgumentParser.parseFormat(parameterFormat, true);
    }

    public Map<String, ArgumentFormat> getOptionFormat() {
        return this.optionFormat;
    }

    public Map<? extends String, ? extends ArgumentFormat> getParameterFormat() {
        return this.parameterFormat;
    }

    protected static Map<String, ArgumentFormat> parseFormat(String format, boolean parameterFormat) {
        LinkedHashMap<String, ArgumentFormat> options = new LinkedHashMap<String, ArgumentFormat>();
        ArgumentFormat last = null;
        StringTokenizer st = new StringTokenizer(format, " ");
        while (st.hasMoreTokens()) {
            ArgumentFormat af;
            block18: {
                String token;
                block12: {
                    token = st.nextToken();
                    if ("..".equals(token)) {
                        if (last != null) {
                            last.vararg = true;
                            break;
                        }
                        throw new IllegalArgumentException("'..' without parameter definition");
                    }
                    last = af = new ArgumentFormat();
                    af.parameter = parameterFormat;
                    af.mandatory = token.charAt(0) != '+';
                    token = token.substring(1);
                    if (!token.endsWith("]")) break block12;
                    af.option = token.substring(0, token.indexOf(91));
                    token = token.substring(af.option.length() + 1, token.length() - 1);
                    StringTokenizer pt = new StringTokenizer(token, ",", true);
                    ArrayList<ArgumentParameter> params = new ArrayList<ArgumentParameter>();
                    Object inRegex = null;
                    int i = 1;
                    while (pt.hasMoreTokens()) {
                        block15: {
                            ArgumentParameter ap;
                            block17: {
                                Object param;
                                block16: {
                                    block14: {
                                        block13: {
                                            param = pt.nextToken();
                                            if (inRegex == null) break block13;
                                            param = inRegex = inRegex + (String)param;
                                            break block14;
                                        }
                                        if (",".equals(param)) break block15;
                                    }
                                    if (((String)param).indexOf(60) > 0 && ((String)param).indexOf(62) < 0) {
                                        inRegex = param;
                                    }
                                    ap = new ArgumentParameter();
                                    ap.name = "" + i;
                                    if (((String)param).endsWith("}")) {
                                        param = ArgumentParser.parseParameterFormat((String)param, ap);
                                    }
                                    if (!((String)param).endsWith(">")) break block16;
                                    inRegex = null;
                                    int regexPos = ((String)param).indexOf(60);
                                    ap.pattern = Pattern.compile(((String)param).substring(regexPos + 1, ((String)param).length() - 1));
                                    param = ((String)param).substring(0, regexPos);
                                    if (((String)param).endsWith("}")) {
                                        ArgumentParser.parseParameterFormat((String)param, ap);
                                    } else {
                                        ap.type = ArgumentParser.getType((String)param);
                                    }
                                    break block17;
                                }
                                if (inRegex != null) break block15;
                                ap.type = ArgumentParser.getType((String)param);
                            }
                            params.add(ap);
                        }
                        ++i;
                    }
                    ArgumentFormat.access$702(af, params.toArray(new ArgumentParameter[params.size()]));
                    break block18;
                }
                af.option = token;
                if (af.parameter) {
                    throw new IllegalArgumentException("Parameter " + token + " has no type");
                }
            }
            options.put(af.option, af);
        }
        return options;
    }

    private static String parseParameterFormat(String param, ArgumentParameter ap) {
        int posEnd = param.indexOf(60);
        posEnd = posEnd > 0 ? posEnd : param.indexOf("{");
        ap.type = ArgumentParser.getType(param.substring(0, posEnd));
        String defaultValue = param.substring(param.indexOf(123) + 1, param.length() - 1);
        int posEqual = defaultValue.indexOf(61);
        if (posEqual >= 0) {
            ap.defaultValue = defaultValue.substring(posEqual + 1);
            ap.name = defaultValue.substring(0, posEqual);
        } else {
            ap.name = defaultValue;
        }
        int posParamEnd = param.indexOf(62);
        if (posParamEnd > 0) {
            posEnd = posParamEnd + 1;
        }
        param = param.substring(0, posEnd);
        return param;
    }

    private static int getType(String type) {
        return Arrays.binarySearch(TYPES, type);
    }

    public Map<String, List<Object>> parse(String[] args) throws ParseException {
        LinkedHashMap<String, List<Object>> options = new LinkedHashMap<String, List<Object>>();
        Iterator<? extends ArgumentFormat> params = this.parameterFormat.values().iterator();
        ArgumentFormat lastFormat = null;
        for (int i = 0; i < args.length; ++i) {
            ArgumentFormat format;
            if (args[i].length() == 0) continue;
            if (args[i].charAt(0) == '-') {
                String option = args[i].substring(1);
                format = this.optionFormat.get(option);
                if (format == null) {
                    throw new ParseException("Unknown option '" + option + "' at position " + i, i);
                }
            } else {
                ArgumentFormat argumentFormat = params.hasNext() ? params.next() : (format = lastFormat != null && lastFormat.isVariableLength() ? lastFormat : null);
                if (format == null) {
                    throw new ParseException("Unrecognized parameter at position " + i, i);
                }
            }
            if (format.getParameters() != null && format.getParameters().length > 0) {
                int diff = format.isParameter() ? 1 : 0;
                List<Object> values = this.parseValues(args, i + (1 - diff), format);
                i += Math.max(values.size() - diff, 0);
                if (format.isVariableLength() && options.containsKey(format.getOption())) {
                    ((List)options.get(format.getOption())).addAll(values);
                } else {
                    this.addValues2Option(format.getOption(), values, options);
                }
            } else {
                this.addValues2Option(format.getOption(), null, options);
            }
            lastFormat = format;
        }
        while (params.hasNext()) {
            ArgumentFormat af = params.next();
            if (!af.isMandatory() || af.getParameters() == null || af.getParameters().length <= 0) continue;
            ArrayList<Object> defaults = new ArrayList<Object>();
            for (ArgumentParameter parameter : af.getParameters()) {
                if (parameter.getDefaultValue() == null) {
                    throw new ArgumentParseException(-1, null, af, parameter);
                }
                defaults.add(this.parseParameterValue(parameter, parameter.getDefaultValue(), af, defaults.size()));
            }
            this.addValues2Option(af.getOption(), defaults, options);
        }
        for (ArgumentFormat of : this.optionFormat.values()) {
            if (!of.isMandatory() || options.containsKey(of.getOption())) continue;
            ArrayList<Object> defaults = new ArrayList<Object>();
            if (of.getParameters() != null) {
                for (int i = 0; i < of.getParameters().length; ++i) {
                    if (of.getParameters()[i] == null || of.getParameters()[i].getDefaultValue() == null) continue;
                    defaults.add(this.parseParameterValue(of.getParameters()[i], of.getParameters()[i].getDefaultValue(), of, i));
                }
            }
            if (defaults.size() == 0) {
                throw new ArgumentParseException(-1, null, of, of.getParameters() != null && of.getParameters().length > 0 ? of.getParameters()[0] : null);
            }
            this.addValues2Option(of.getOption(), defaults, options);
        }
        return options;
    }

    protected void addValues2Option(String option, List<Object> values, Map<String, List<Object>> options) {
        List<Object> existingValues = options.get(option);
        if (existingValues != null && values != null) {
            existingValues.addAll(values);
        } else {
            options.put(option, values);
        }
    }

    protected List<Object> parseValues(String[] args, int offset, ArgumentFormat format) throws ParseException {
        int numParams = format.getParameters().length;
        ArrayList<Object> values = new ArrayList<Object>(numParams);
        for (int i = 0; i + offset < args.length && i < numParams; ++i) {
            try {
                values.add(this.parseParameterValue(format.getParameters()[i], args[i + offset], format, i + offset));
                continue;
            }
            catch (ArgumentParseException apex) {
                throw apex;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                int pos = i + offset;
                throw new ArgumentParseException(pos, args[pos], format, format.getParameters()[i]);
            }
        }
        return values;
    }

    protected Object parseParameterValue(ArgumentParameter type, String value, ArgumentFormat format, int pos) throws ArgumentParseException {
        Matcher m;
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 2);
        }
        if (type.pattern != null && !(m = type.pattern.matcher(value)).matches()) {
            throw new ArgumentParseException("Value '" + value + "' for " + (format.isParameter() ? "parameter " : "option ") + format.getOption() + (String)(format.getParameters().length > 1 ? " part " + type.getName() : "") + " does not match pattern '" + type.pattern.pattern() + "'", pos, value, format, type);
        }
        switch (type.getType()) {
            case 0: {
                return Integer.valueOf(value);
            }
            case 1: {
                return Long.valueOf(value);
            }
            case 3: {
                return OctetString.fromHexString(value, ':');
            }
        }
        return value;
    }

    public static Object getFirstValue(List<? extends Object> optionValues) {
        if (optionValues != null && optionValues.size() > 0) {
            return optionValues.get(0);
        }
        return null;
    }

    public static Object getValue(Map<String, List<Object>> args, String name, int index) {
        List<Object> values = args.get(name);
        if (values != null && values.size() > index) {
            return values.get(index);
        }
        return null;
    }

    public static void main(String[] args) {
        ArgumentParser argumentparser = new ArgumentParser(System.getProperty("org.snmp4j.OptionFormat", "-o1[i{parameter1}] -o2[s,l]"), System.getProperty("org.snmp4j.ParameterFormat", "-param1[i] -param2[s<(udp|tcp):.*[/[0-9]+]?>{=udp:127.0.0.1/161}] +optParam1[l{=-100}] .."));
        System.out.println("Option format is: " + argumentparser.getOptionFormat());
        System.out.println("Parameter format is: " + argumentparser.getParameterFormat());
        Map<String, List<Object>> options = null;
        try {
            options = argumentparser.parse(args);
            System.out.println(options);
        }
        catch (ParseException ex) {
            System.err.println("Failed to parse args: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static String[] selectCommand(String[] args, String optionFormat, String[][] commandSets) throws ParseException {
        ArgumentParser ap = new ArgumentParser(optionFormat, "#command[s] +following[s] ..");
        Map<String, List<Object>> params = ap.parse(args);
        String command = (String)ArgumentParser.getValue(params, "command", 0);
        for (String[] commandSet : commandSets) {
            if (!commandSet[0].equals(command)) continue;
            return commandSet;
        }
        throw new ParseException("Command '" + command + "' not found", 0);
    }

    public static class ArgumentParseException
    extends ParseException {
        private static final long serialVersionUID = -5696562294165746262L;
        private ArgumentParameter parameterFormatDetail;
        private ArgumentFormat parameterFormat;
        private String value;

        public ArgumentParseException(int position, String value, ArgumentFormat parameterFormat, ArgumentParameter parameterFormatDetail) {
            super(value != null ? "Invalid value '" + value + "' at position " + position : "Mandatory parameter " + (parameterFormat == null ? "<unknown>" : parameterFormat.getOption()) + "(" + (parameterFormatDetail == null ? "<unknown>" : parameterFormatDetail.getName()) + ") not specified", position);
            this.parameterFormat = parameterFormat;
            this.parameterFormatDetail = parameterFormatDetail;
            this.value = value;
        }

        public ArgumentParseException(String message, int position, String value, ArgumentFormat parameterFormat, ArgumentParameter parameterFormatDetail) {
            super(message, position);
            this.parameterFormat = parameterFormat;
            this.parameterFormatDetail = parameterFormatDetail;
            this.value = value;
        }

        public ArgumentParameter getParameterFormatDetail() {
            return this.parameterFormatDetail;
        }

        public ArgumentFormat getParameterFormat() {
            return this.parameterFormat;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ArgumentParameter
    implements Serializable {
        private static final long serialVersionUID = 4644762496770664403L;
        private String name;
        private int type;
        private Pattern pattern;
        private String defaultValue;

        public String getName() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public int getType() {
            return this.type;
        }

        public String toString() {
            return "ArgumentParameter[name=" + this.name + ",type=" + this.type + ",patttern=" + (this.pattern == null ? null : this.pattern.pattern()) + ",defaultValue=" + this.defaultValue + "]";
        }
    }

    public static class ArgumentFormat
    implements Serializable {
        private static final long serialVersionUID = 5473087181068297879L;
        private String option;
        private boolean mandatory;
        private boolean parameter;
        private ArgumentParameter[] params;
        private boolean vararg;

        public boolean isMandatory() {
            return this.mandatory;
        }

        public boolean isParameter() {
            return this.parameter;
        }

        public String getOption() {
            return this.option;
        }

        public ArgumentParameter[] getParameters() {
            return this.params;
        }

        public boolean isVariableLength() {
            return this.vararg;
        }

        public String toString() {
            return "ArgumentFormat[option=" + this.option + ",parameter=" + this.parameter + ",vararg=" + this.vararg + ",mandatatory=" + this.mandatory + ",parameters=" + (this.params == null ? "<null>" : Arrays.asList(this.params).toString()) + "]";
        }

        static /* synthetic */ ArgumentParameter[] access$702(ArgumentFormat x0, ArgumentParameter[] x1) {
            x0.params = x1;
            return x1;
        }
    }
}

