/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.filewatch;

import io.questdb.FileEventCallback;
import io.questdb.KqueueFileWatcher;
import io.questdb.network.EpollFacadeImpl;
import io.questdb.std.Os;
import io.questdb.std.filewatch.FileWatcher;
import io.questdb.std.filewatch.FileWatcherWindows;
import io.questdb.std.filewatch.LinuxAccessorFacadeImpl;
import io.questdb.std.filewatch.LinuxFileWatcher;
import io.questdb.std.filewatch.WindowsAccessorImpl;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public class FileWatcherFactory {
    public static FileWatcher getFileWatcher(@NotNull Utf8Sequence filePath, @NotNull FileEventCallback callback) {
        if (filePath.size() == 0) {
            throw new IllegalArgumentException("file to watch cannot be empty");
        }
        if (Os.isOSX() || Os.isFreeBSD()) {
            return new KqueueFileWatcher(filePath, callback);
        }
        if (Os.isWindows()) {
            return new FileWatcherWindows(WindowsAccessorImpl.INSTANCE, filePath, callback);
        }
        return new LinuxFileWatcher(LinuxAccessorFacadeImpl.INSTANCE, EpollFacadeImpl.INSTANCE, filePath, callback);
    }
}

