/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.IntervalUtils;
import io.questdb.std.Hash;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.NumericException;
import io.questdb.std.datetime.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;

public class Interval
implements Sinkable,
Mutable {
    public static final Interval NULL = new Interval(Long.MIN_VALUE, Long.MIN_VALUE);
    private long hi = Long.MIN_VALUE;
    private long lo = Long.MIN_VALUE;

    public Interval() {
    }

    public Interval(long lo, long hi) {
        this.of(lo, hi);
    }

    @Override
    public void clear() {
        this.lo = Long.MIN_VALUE;
        this.hi = Long.MIN_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != Interval.class) {
            return false;
        }
        Interval that = (Interval)o;
        return this.lo == that.lo && this.hi == that.hi;
    }

    public long getHi() {
        return this.hi;
    }

    public long getLo() {
        return this.lo;
    }

    public int hashCode() {
        return Hash.hashLong128_32(this.lo, this.hi);
    }

    public Interval of(long lo, long hi) {
        this.lo = lo;
        this.hi = hi;
        return this;
    }

    public void of(CharSequence seq, LongList list) throws NumericException, SqlException {
        IntervalUtils.parseInterval(seq, 0, seq.length(), (short)0, list);
        assert (list.size() != 0);
        if (list.size() != 2) {
            throw SqlException.$(-1, "only compatible with simple intervals");
        }
        this.lo = list.get(0);
        this.hi = list.get(1);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii('(');
        if (this.lo != Long.MIN_VALUE) {
            sink.putAscii('\'');
            sink.put(Timestamps.toString(this.lo));
            sink.putAscii('\'');
        } else {
            sink.putAscii("null");
        }
        sink.putAscii(", ");
        if (this.hi != Long.MIN_VALUE) {
            sink.putAscii('\'');
            sink.put(Timestamps.toString(this.hi));
            sink.putAscii('\'');
        } else {
            sink.putAscii("null");
        }
        sink.put(')');
    }
}

