/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.std.Mutable;
import io.questdb.std.Unsafe;
import io.questdb.std.str.AsciiCharSequence;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogRecordUtf8Sink
implements Utf8Sink,
DirectUtf8Sequence,
Sinkable,
Mutable {
    public static final int EOL_LENGTH = "\r\n".length();
    private static final int UTF8_BYTE_CLASS_BAD = -1;
    private static final int UTF8_BYTE_CLASS_CONTINUATION = 0;
    protected final long address;
    protected final long lim;
    private final AsciiCharSequence asciiCharSequence = new AsciiCharSequence();
    protected long _wptr;
    private boolean done = false;
    private int level;

    public LogRecordUtf8Sink(long address, long addressSize) {
        this.address = this._wptr = address;
        this.lim = address + addressSize;
    }

    @Override
    @NotNull
    public CharSequence asAsciiCharSequence() {
        return this.asciiCharSequence.of(this);
    }

    @Override
    public byte byteAt(int index) {
        return Unsafe.getUnsafe().getByte(this.address + (long)index);
    }

    @Override
    public void clear() {
        this._wptr = this.address;
        this.done = false;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public long ptr() {
        return this.address;
    }

    @Override
    public Utf8Sink put(@Nullable Utf8Sequence us) {
        if (us != null) {
            int rem = (int)(this.lim - this._wptr - (long)EOL_LENGTH);
            int size = us.size();
            if (rem >= size) {
                Utf8s.strCpy(us, size, this._wptr);
                this._wptr += (long)size;
                return this;
            }
            int safeLen = rem - 4;
            if (safeLen > 0) {
                Utf8s.strCpy(us, safeLen, this._wptr);
                this._wptr += (long)safeLen;
            }
            for (int i = safeLen = Math.max(0, safeLen); i < rem; ++i) {
                this.put(us.byteAt(i));
            }
            return this;
        }
        return this;
    }

    @Override
    public Utf8Sink put(byte b) {
        long left = this.lim - this._wptr - (long)EOL_LENGTH;
        if (left >= 4L) {
            Unsafe.getUnsafe().putByte(this._wptr++, b);
            return this;
        }
        if (this.done) {
            return this;
        }
        long needed = this.utf8CharNeeded(b);
        if (needed == -1L) {
            b = (byte)63;
            needed = 1L;
        }
        if (left >= needed) {
            Unsafe.getUnsafe().putByte(this._wptr++, b);
        } else {
            this.done = true;
        }
        return this;
    }

    @Override
    public Utf8Sink putEOL() {
        int rem = (int)(this.lim - this._wptr);
        int len = "\r\n".length();
        int n = Math.min(rem, len);
        Utf8s.strCpyAscii("\r\n", n, this._wptr);
        this._wptr += (long)n;
        return this;
    }

    @Override
    public Utf8Sink putNonAscii(long lo, long hi) {
        long rem = this.lim - this._wptr - (long)EOL_LENGTH;
        long size = hi - lo;
        if (rem >= size) {
            Unsafe.getUnsafe().copyMemory(lo, this._wptr, size);
            this._wptr += size;
            return this;
        }
        long safeLen = rem - 4L;
        if (safeLen > 0L) {
            Unsafe.getUnsafe().copyMemory(lo, this._wptr, safeLen);
            this._wptr += safeLen;
        }
        for (long i = safeLen = Math.max(0L, safeLen); i < rem; ++i) {
            this.put(Unsafe.getUnsafe().getByte(lo + i));
        }
        return this;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int size() {
        return (int)(this._wptr - this.address);
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        switch (sink.getEncoding()) {
            case 8: {
                sink.putNonAscii(this.address, this._wptr);
                break;
            }
            case 16: {
                Utf8s.utf8ToUtf16(this.address, this._wptr, (Utf16Sink)sink);
                break;
            }
            default: {
                assert (false) : "unsupported sink encoding";
                break;
            }
        }
    }

    @NotNull
    public String toString() {
        return Utf8s.stringFromUtf8Bytes(this.address, this._wptr);
    }

    private static int utf8ByteClass(byte b) {
        if (b >= 0) {
            return 1;
        }
        if ((b & 0xC0) == 128) {
            return 0;
        }
        if ((b & 0xE0) == 192) {
            return 2;
        }
        if ((b & 0xF0) == 224) {
            return 3;
        }
        if ((b & 0xF8) == 240) {
            return 4;
        }
        return -1;
    }

    private int utf8CharNeeded(byte b) {
        int byteClass = LogRecordUtf8Sink.utf8ByteClass(b);
        switch (byteClass) {
            case -1: {
                return -1;
            }
            case 0: {
                long ptr;
                int multibyteLength = -1;
                long boundary = Math.max(this.address, this._wptr - 4L);
                block8: for (ptr = this._wptr - 1L; ptr >= boundary; --ptr) {
                    byte prev = Unsafe.getUnsafe().getByte(ptr);
                    multibyteLength = LogRecordUtf8Sink.utf8ByteClass(prev);
                    switch (multibyteLength) {
                        case -1: {
                            return -1;
                        }
                        case 0: {
                            continue block8;
                        }
                    }
                }
                if ((multibyteLength -= (int)(this._wptr - ptr)) < 1) {
                    multibyteLength = -1;
                }
                return multibyteLength;
            }
        }
        return byteClass;
    }
}

