/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.window;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.AbstractVirtualFunctionRecordCursor;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class WindowRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final WindowRecordCursor cursor;
    private final ObjList<Function> functions;
    private final ObjList<WindowFunction> windowFunctions;
    private final int windowFunctionsCount;
    private boolean closed = false;

    public WindowRecordCursorFactory(RecordCursorFactory base, GenericRecordMetadata metadata, ObjList<Function> functions) {
        super(metadata);
        this.base = base;
        this.functions = functions;
        this.windowFunctions = new ObjList();
        int n = functions.size();
        for (int i = 0; i < n; ++i) {
            Function func = functions.getQuick(i);
            if (!(func instanceof WindowFunction)) continue;
            this.windowFunctions.add((WindowFunction)func);
        }
        this.windowFunctionsCount = this.windowFunctions.size();
        this.cursor = new WindowRecordCursor(functions, false);
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.base.followedOrderByAdvice();
    }

    @Override
    public RecordCursorFactory getBaseFactory() {
        return this.base;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        executionContext.setColumnPreTouchEnabled(false);
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        this.cursor.of(baseCursor, executionContext);
        return this.cursor;
    }

    @Override
    public int getScanDirection() {
        return this.base.getScanDirection();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Window");
        sink.optAttr((CharSequence)"functions", this.windowFunctions, true);
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    private void resetFunctions() {
        int n = this.windowFunctions.size();
        for (int i = 0; i < n; ++i) {
            this.windowFunctions.getQuick(i).reset();
        }
    }

    @Override
    protected void _close() {
        if (this.closed) {
            return;
        }
        Misc.free(this.base);
        Misc.free(this.cursor);
        Misc.freeObjList(this.functions);
        this.closed = true;
    }

    class WindowRecordCursor
    extends AbstractVirtualFunctionRecordCursor {
        private SqlExecutionCircuitBreaker circuitBreaker;
        private boolean isOpen;

        public WindowRecordCursor(ObjList<Function> functions, boolean supportsRandomAccess) {
            super(functions, supportsRandomAccess);
            this.isOpen = true;
        }

        @Override
        public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
            this.baseCursor.calculateSize(circuitBreaker, counter);
        }

        @Override
        public void close() {
            if (this.isOpen) {
                super.close();
                WindowRecordCursorFactory.this.resetFunctions();
                this.isOpen = false;
            }
        }

        @Override
        public boolean hasNext() {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            boolean hasNext = super.hasNext();
            if (hasNext) {
                for (int i = 0; i < WindowRecordCursorFactory.this.windowFunctionsCount; ++i) {
                    WindowRecordCursorFactory.this.windowFunctions.getQuick(i).computeNext(this.baseCursor.getRecord());
                }
            }
            return hasNext;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
            RecordCursor.skipRows(this, rowCount);
        }

        @Override
        public void toTop() {
            int n = WindowRecordCursorFactory.this.functions.size();
            for (int i = 0; i < n; ++i) {
                WindowRecordCursorFactory.this.functions.getQuick(i).toTop();
            }
            this.baseCursor.toTop();
        }

        private void of(RecordCursor baseCursor, SqlExecutionContext executionContext) throws SqlException {
            super.of(baseCursor);
            this.circuitBreaker = executionContext.getCircuitBreaker();
            if (!this.isOpen) {
                this.isOpen = true;
                try {
                    this.reopen(WindowRecordCursorFactory.this.functions);
                }
                catch (Throwable t) {
                    this.close();
                    throw t;
                }
            }
            Function.init(WindowRecordCursorFactory.this.functions, baseCursor, executionContext, null);
        }

        private void reopen(ObjList<Function> list) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Function function = list.getQuick(i);
                if (!(function instanceof Reopenable)) continue;
                ((Reopenable)((Object)function)).reopen();
            }
        }
    }
}

