/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractPageFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.Rows;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LatestByValuesIndexedRecordCursor
extends AbstractPageFrameRecordCursor {
    private final int columnIndex;
    private final IntHashSet deferredSymbolKeys;
    private final IntHashSet found = new IntHashSet();
    private final DirectLongList rows;
    private final IntHashSet symbolKeys;
    private SqlExecutionCircuitBreaker circuitBreaker;
    private long index = 0L;
    private boolean isTreeMapBuilt;
    private int keyCount;

    public LatestByValuesIndexedRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, int columnIndex, @NotNull IntHashSet symbolKeys, @Nullable IntHashSet deferredSymbolKeys, DirectLongList rows) {
        super(configuration, metadata);
        this.rows = rows;
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.deferredSymbolKeys = deferredSymbolKeys;
    }

    @Override
    public boolean hasNext() {
        this.buildTreeMapConditionally();
        if (this.index > -1L) {
            long rowId = this.rows.get(this.index);
            this.frameMemoryPool.navigateTo(Rows.toPartitionIndex(rowId), this.recordA);
            this.recordA.setRowIndex(Rows.toLocalRowID(rowId));
            --this.index;
            return true;
        }
        return false;
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) {
        this.frameCursor = pageFrameCursor;
        this.recordA.of(pageFrameCursor);
        this.recordB.of(pageFrameCursor);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.keyCount = -1;
        this.rows.clear();
        this.found.clear();
        this.isTreeMapBuilt = false;
        super.init();
    }

    @Override
    public long size() {
        return this.isTreeMapBuilt ? this.rows.size() : -1L;
    }

    @Override
    public long preComputedStateSize() {
        return (long)(this.isTreeMapBuilt ? 1 : 0) + this.rows.size();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
    }

    @Override
    public void toTop() {
        this.index = this.rows.size() - 1L;
    }

    private void addFoundKey(int symbolKey, BitmapIndexReader indexReader, int frameIndex, long partitionLo, long partitionHi) {
        RowCursor cursor;
        int index = this.found.keyIndex(symbolKey);
        if (index > -1 && (cursor = indexReader.getCursor(false, symbolKey, partitionLo, partitionHi)).hasNext()) {
            long rowId = Rows.toRowID(frameIndex, cursor.next());
            this.rows.add(rowId);
            this.found.addAt(index, symbolKey);
        }
    }

    private void buildTreeMap() {
        PageFrame frame;
        if (this.keyCount < 0) {
            this.keyCount = this.symbolKeys.size();
            if (this.deferredSymbolKeys != null) {
                this.keyCount += this.deferredSymbolKeys.size();
            }
        }
        while ((frame = this.frameCursor.next()) != null && this.found.size() < this.keyCount) {
            int symbolKey;
            int i;
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            int frameIndex = this.frameCount;
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            int n = this.symbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.symbolKeys.get(i);
                this.addFoundKey(symbolKey, indexReader, frameIndex, partitionLo, partitionHi);
            }
            if (this.deferredSymbolKeys == null) continue;
            n = this.deferredSymbolKeys.size();
            for (i = 0; i < n; ++i) {
                symbolKey = this.deferredSymbolKeys.get(i);
                if (this.symbolKeys.contains(symbolKey)) continue;
                this.addFoundKey(symbolKey, indexReader, frameIndex, partitionLo, partitionHi);
            }
        }
        this.index = this.rows.size() - 1L;
    }

    private void buildTreeMapConditionally() {
        if (!this.isTreeMapBuilt) {
            this.buildTreeMap();
            this.isTreeMapBuilt = true;
        }
    }
}

