/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.PageFrame;
import io.questdb.cairo.sql.PageFrameCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractLatestByValueRecordCursor;
import org.jetbrains.annotations.NotNull;

class LatestByValueRecordCursor
extends AbstractLatestByValueRecordCursor {
    public LatestByValueRecordCursor(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, int columnIndex, int symbolKey) {
        super(configuration, metadata, columnIndex, symbolKey);
    }

    @Override
    public boolean hasNext() {
        if (!this.isFindPending) {
            this.findRecord();
            this.toTop();
            this.isFindPending = true;
        }
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void of(PageFrameCursor pageFrameCursor, SqlExecutionContext executionContext) {
        this.frameCursor = pageFrameCursor;
        this.recordA.of(pageFrameCursor);
        this.recordB.of(pageFrameCursor);
        this.circuitBreaker = executionContext.getCircuitBreaker();
        this.isRecordFound = false;
        this.isFindPending = false;
        super.init();
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public long preComputedStateSize() {
        return this.isFindPending ? 1L : 0L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Row backward scan");
        sink.attr("symbolFilter").putColumnName(this.columnIndex).val('=').val(this.symbolKey);
    }

    @Override
    public void toTop() {
        this.hasNext = this.isRecordFound;
    }

    private void findRecord() {
        PageFrame frame;
        block0: while ((frame = this.frameCursor.next()) != null) {
            this.circuitBreaker.statefulThrowExceptionIfTripped();
            long partitionLo = frame.getPartitionLo();
            long partitionHi = frame.getPartitionHi() - 1L;
            this.frameAddressCache.add(this.frameCount, frame);
            this.frameMemoryPool.navigateTo(this.frameCount++, this.recordA);
            for (long row = partitionHi - partitionLo; row >= 0L; --row) {
                this.recordA.setRowIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (key != this.symbolKey) continue;
                this.isRecordFound = true;
                break block0;
            }
        }
    }
}

