/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Chars;
import io.questdb.std.Misc;

public class RecordAsAFieldRecordCursorFactory
extends AbstractRecordCursorFactory {
    private final RecordCursorFactory base;
    private final RecordAsAFieldRecordCursor cursor;

    public RecordAsAFieldRecordCursorFactory(RecordCursorFactory base, CharSequence columnAlias) {
        super(new GenericRecordMetadata());
        this.base = base;
        this.cursor = new RecordAsAFieldRecordCursor(base.recordCursorSupportsRandomAccess());
        GenericRecordMetadata metadata = (GenericRecordMetadata)this.getMetadata();
        metadata.add(new TableColumnMetadata(Chars.toString(columnAlias), 22, base.getMetadata()));
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        try {
            this.cursor.of(baseCursor, executionContext);
            return this.cursor;
        }
        catch (Throwable th) {
            this.cursor.close();
            throw th;
        }
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return this.base.recordCursorSupportsRandomAccess();
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("RecordAsAField");
        sink.child(this.base);
    }

    @Override
    public boolean usesCompiledFilter() {
        return this.base.usesCompiledFilter();
    }

    @Override
    public boolean usesIndex() {
        return this.base.usesIndex();
    }

    @Override
    protected void _close() {
        Misc.free(this.base);
    }

    private static final class RecordAsAFieldRecordCursor
    implements DelegatingRecordCursor {
        private final RecordAsAFieldRecord record = new RecordAsAFieldRecord();
        private final RecordAsAFieldRecord recordB;
        private RecordCursor baseCursor;

        public RecordAsAFieldRecordCursor(boolean baseSupportsRandomAccess) {
            this.recordB = baseSupportsRandomAccess ? new RecordAsAFieldRecord() : null;
        }

        @Override
        public void close() {
            this.baseCursor = Misc.free(this.baseCursor);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public Record getRecordB() {
            if (this.recordB != null) {
                return this.recordB;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.baseCursor.hasNext();
        }

        @Override
        public void of(RecordCursor baseCursor, SqlExecutionContext executionContext) {
            this.baseCursor = baseCursor;
            this.record.base = baseCursor.getRecord();
            if (this.recordB != null) {
                this.recordB.base = baseCursor.getRecordB();
            }
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public void recordAt(Record record, long atRowId) {
            this.baseCursor.recordAt(((RecordAsAFieldRecord)record).base, atRowId);
        }

        @Override
        public long size() {
            return this.baseCursor.size();
        }

        @Override
        public void toTop() {
            this.baseCursor.toTop();
        }
    }

    private static final class RecordAsAFieldRecord
    implements Record {
        private Record base;

        private RecordAsAFieldRecord() {
        }

        @Override
        public Record getRecord(int col) {
            assert (col == 0);
            return this.base;
        }
    }
}

