/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.Long256Function;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.mp.SimpleSpinLock;
import io.questdb.std.Long256;
import io.questdb.std.Long256Impl;
import io.questdb.std.Long256Util;
import io.questdb.std.Rosti;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import java.util.concurrent.atomic.LongAdder;

public class SumLong256VectorAggregateFunction
extends Long256Function
implements VectorAggregateFunction {
    private static final ThreadLocal<Long256Impl> partialSums = new ThreadLocal<Long256Impl>(Long256Impl::new);
    private final int columnIndex;
    private final LongAdder count = new LongAdder();
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private final SimpleSpinLock lock = new SimpleSpinLock();
    private final Long256Impl sumA = new Long256Impl();
    private final Long256Impl sumB = new Long256Impl();
    private int valueOffset;

    public SumLong256VectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        this.columnIndex = columnIndex;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourSumLong256;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntSumLong256;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(long address, long frameRowCount, int workerId) {
        Long256Impl value;
        if (address != 0L && (value = this.sumLong256(partialSums.get(), address, frameRowCount)) != Long256Impl.NULL_LONG256) {
            this.lock.lock();
            try {
                Long256Util.add(this.sumA, value);
                this.count.increment();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long frameRowCount) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, frameRowCount);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, frameRowCount, this.valueOffset);
    }

    @Override
    public void clear() {
        this.sumA.setAll(0L, 0L, 0L, 0L);
        this.sumB.setAll(0L, 0L, 0L, 0L);
        this.count.reset();
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public void getLong256(Record rec, CharSink<?> sink) {
        Long256Impl v = (Long256Impl)this.getLong256A(rec);
        v.toSink(sink);
    }

    @Override
    public Long256 getLong256A(Record rec) {
        if (this.count.sum() > 0L) {
            return this.sumA;
        }
        return Long256Impl.NULL_LONG256;
    }

    @Override
    public Long256 getLong256B(Record rec) {
        if (this.count.sum() > 0L) {
            this.sumB.copyFrom(this.sumA);
            return this.sumB;
        }
        return Long256Impl.NULL_LONG256;
    }

    @Override
    public String getName() {
        return "sum";
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0L);
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset) + 8L, 0L);
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset) + 16L, 0L);
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset) + 24L, 0L);
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 1), 0L);
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntSumLong256Merge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(13);
        types.add(6);
    }

    @Override
    public boolean wrapUp(long pRosti) {
        return Rosti.keyedIntSumLong256WrapUp(pRosti, this.valueOffset, this.sumA.getLong0(), this.sumA.getLong1(), this.sumA.getLong2(), this.sumA.getLong3(), this.count.sum());
    }

    private Long256Impl sumLong256(Long256Impl sum, long address, long count) {
        boolean hasData = false;
        long offset = 0L;
        sum.setAll(0L, 0L, 0L, 0L);
        for (long i = 0L; i < count; ++i) {
            boolean isNull;
            long l0 = Unsafe.getUnsafe().getLong(address + offset);
            long l1 = Unsafe.getUnsafe().getLong(address + offset + 8L);
            long l2 = Unsafe.getUnsafe().getLong(address + offset + 16L);
            long l3 = Unsafe.getUnsafe().getLong(address + offset + 24L);
            boolean bl = isNull = l0 == Long.MIN_VALUE && l1 == Long.MIN_VALUE && l2 == Long.MIN_VALUE && l3 == Long.MIN_VALUE;
            if (!isNull) {
                Long256Util.add(sum, l0, l1, l2, l3);
                hasData = true;
            }
            offset += 32L;
        }
        return hasData ? sum : Long256Impl.NULL_LONG256;
    }
}

