/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.hyperloglog;

import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.hyperloglog.BiasCorrectionData;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.Arrays;

public class HyperLogLogDenseRepresentation {
    private static final long HEADER_SIZE = 9L;
    private static final int KNN_K = 6;
    private static final double[] RECIPROCALS_OF_POWER_OF_2 = new double[62];
    private final double alphaMM;
    private final int biasCorrectionDataIndex;
    private final int biasCorrectionThreshold;
    private final long leadingZerosMask;
    private final int precision;
    private final int registerCount;
    private GroupByAllocator allocator;
    private long ptr;

    public HyperLogLogDenseRepresentation(int precision) {
        this.registerCount = 1 << precision;
        this.precision = precision;
        this.biasCorrectionThreshold = 5 * this.registerCount;
        this.biasCorrectionDataIndex = precision - 4;
        this.leadingZerosMask = 1L << precision - 1;
        switch (this.registerCount) {
            case 16: {
                this.alphaMM = 0.673 * (double)this.registerCount * (double)this.registerCount;
                break;
            }
            case 32: {
                this.alphaMM = 0.697 * (double)this.registerCount * (double)this.registerCount;
                break;
            }
            case 64: {
                this.alphaMM = 0.709 * (double)this.registerCount * (double)this.registerCount;
                break;
            }
            default: {
                this.alphaMM = 0.7213 / (1.0 + 1.079 / (double)this.registerCount) * (double)this.registerCount * (double)this.registerCount;
            }
        }
    }

    public void add(long hash) {
        int registerIdx = this.computeRegisterIndex(hash);
        byte leadingZeros = this.computeNumberOfLeadingZeros(hash);
        this.add(registerIdx, leadingZeros);
    }

    public long computeCardinality() {
        double rawEstimate;
        double h;
        double sum = 0.0;
        int emptyRegisterCount = 0;
        for (int i = 0; i < this.registerCount; ++i) {
            byte registerValue = this.get(i);
            sum += RECIPROCALS_OF_POWER_OF_2[registerValue];
            if (registerValue != 0) continue;
            ++emptyRegisterCount;
        }
        if (emptyRegisterCount > 0 && (h = HyperLogLogDenseRepresentation.linearCounting(this.registerCount, emptyRegisterCount)) < BiasCorrectionData.THRESHOLD_DATA[this.biasCorrectionDataIndex]) {
            return Math.round(h);
        }
        double correctedEstimate = rawEstimate = this.alphaMM * (1.0 / sum);
        if (rawEstimate <= (double)this.biasCorrectionThreshold) {
            correctedEstimate = rawEstimate - this.estimateBias(rawEstimate);
        }
        return Math.round(correctedEstimate);
    }

    public double estimateBias(double estimate) {
        double[] rawEstimateVector = BiasCorrectionData.RAW_ESTIMATE_DATA[this.biasCorrectionDataIndex];
        int nearest = Arrays.binarySearch(rawEstimateVector, estimate);
        int left = nearest = nearest >= 0 ? nearest : Math.max(-(nearest + 1) - 1, 0);
        int right = nearest + 1;
        int n = 5;
        for (int i = 0; i < n; ++i) {
            if (left - 1 < 0) {
                ++right;
                continue;
            }
            if (right == rawEstimateVector.length) {
                --left;
                continue;
            }
            double leftDistance = estimate - rawEstimateVector[left - 1];
            double rightDistance = rawEstimateVector[right] - estimate;
            if (leftDistance < rightDistance) {
                --left;
                continue;
            }
            ++right;
        }
        double[] biasVector = BiasCorrectionData.BIAS_DATA[this.biasCorrectionDataIndex];
        double biasTotal = 0.0;
        for (int i = left; i < right; ++i) {
            biasTotal += biasVector[i];
        }
        return biasTotal / 6.0;
    }

    public HyperLogLogDenseRepresentation of(long ptr) {
        if (ptr == 0L) {
            this.ptr = this.allocator.malloc(9L + (long)this.registerCount);
            Vect.memset(this.ptr + 9L, this.registerCount, 0);
        } else {
            this.ptr = ptr;
        }
        return this;
    }

    public long ptr() {
        return this.ptr;
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    private static double linearCounting(int total, int empty) {
        return (double)total * Math.log((double)total / (double)empty);
    }

    private byte computeNumberOfLeadingZeros(long hash) {
        return (byte)(Long.numberOfLeadingZeros(hash << this.precision | this.leadingZerosMask) + 1);
    }

    private int computeRegisterIndex(long hash) {
        return (int)(hash >>> 64 - this.precision);
    }

    private byte get(int idx) {
        return Unsafe.getUnsafe().getByte(this.ptr + 9L + (long)idx);
    }

    private void set(int idx, byte val) {
        Unsafe.getUnsafe().putByte(this.ptr + 9L + (long)idx, val);
    }

    static long calculateSizeInBytes(int precision) {
        int registerCount = 1 << precision;
        return 9L + (long)registerCount;
    }

    void add(int position, byte value) {
        byte curVal = this.get(position);
        if (curVal < value) {
            this.set(position, value);
        }
    }

    void copyTo(HyperLogLogDenseRepresentation dst) {
        for (int i = 0; i < this.registerCount; ++i) {
            byte srcVal = this.get(i);
            dst.add(i, srcVal);
        }
    }

    static {
        for (int i = 0; i < RECIPROCALS_OF_POWER_OF_2.length; ++i) {
            HyperLogLogDenseRepresentation.RECIPROCALS_OF_POWER_OF_2[i] = Math.pow(2.0, -i);
        }
    }
}

