/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionParser;
import io.questdb.griffin.PriorityMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.SymbolFunction;
import io.questdb.griffin.engine.functions.cast.CastStrToSymbolFunctionFactory;
import io.questdb.griffin.engine.functions.columns.ArrayColumn;
import io.questdb.griffin.engine.functions.columns.BinColumn;
import io.questdb.griffin.engine.functions.columns.BooleanColumn;
import io.questdb.griffin.engine.functions.columns.ByteColumn;
import io.questdb.griffin.engine.functions.columns.CharColumn;
import io.questdb.griffin.engine.functions.columns.DateColumn;
import io.questdb.griffin.engine.functions.columns.DoubleColumn;
import io.questdb.griffin.engine.functions.columns.FloatColumn;
import io.questdb.griffin.engine.functions.columns.GeoByteColumn;
import io.questdb.griffin.engine.functions.columns.GeoIntColumn;
import io.questdb.griffin.engine.functions.columns.GeoLongColumn;
import io.questdb.griffin.engine.functions.columns.GeoShortColumn;
import io.questdb.griffin.engine.functions.columns.IPv4Column;
import io.questdb.griffin.engine.functions.columns.IntColumn;
import io.questdb.griffin.engine.functions.columns.IntervalColumn;
import io.questdb.griffin.engine.functions.columns.Long128Column;
import io.questdb.griffin.engine.functions.columns.Long256Column;
import io.questdb.griffin.engine.functions.columns.LongColumn;
import io.questdb.griffin.engine.functions.columns.ShortColumn;
import io.questdb.griffin.engine.functions.columns.StrColumn;
import io.questdb.griffin.engine.functions.columns.TimestampColumn;
import io.questdb.griffin.engine.functions.columns.UuidColumn;
import io.questdb.griffin.engine.functions.columns.VarcharColumn;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.griffin.engine.groupby.MapSymbolColumn;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import java.util.ArrayDeque;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupByUtils {
    public static final int PROJECTION_FUNCTION_FLAG_ANY = -1;
    public static final int PROJECTION_FUNCTION_FLAG_COLUMN = 0;
    public static final int PROJECTION_FUNCTION_FLAG_GROUP_BY = 2;
    public static final int PROJECTION_FUNCTION_FLAG_VIRTUAL = 1;

    public static void assembleGroupByFunctions(@NotNull FunctionParser functionParser, @NotNull ArrayDeque<ExpressionNode> sqlNodeStack, QueryModel model, SqlExecutionContext executionContext, RecordMetadata baseMetadata, int timestampIndex, boolean timestampUnimportant, ObjList<GroupByFunction> outGroupByFunctions, IntList outGroupByFunctionPositions, ObjList<Function> outerProjectionFunctions, ObjList<Function> innerProjectionFunctions, IntList projectionFunctionPositions, IntList projectionFunctionFlags, GenericRecordMetadata projectionMetadata, PriorityMetadata outPriorityMetadata, ArrayColumnTypes outValueTypes, ArrayColumnTypes outKeyTypes, ListColumnFilter outColumnFilter, @Nullable ObjList<ExpressionNode> sampleByFill, boolean validateFill) throws SqlException {
        try {
            int valueCount;
            ExpressionNode node;
            QueryColumn column;
            int i;
            outGroupByFunctionPositions.clear();
            projectionFunctionPositions.clear();
            int fillCount = sampleByFill != null ? sampleByFill.size() : 0;
            int columnKeyCount = 0;
            int lastIndex = -1;
            ObjList<QueryColumn> columns = model.getColumns();
            int n = columns.size();
            for (i = 0; i < n; ++i) {
                column = columns.getQuick(i);
                node = column.getAst();
                int index = baseMetadata.getColumnIndexQuiet(node.token);
                TableColumnMetadata m = null;
                if (node.type != 7 || index != timestampIndex || timestampUnimportant) {
                    Function func = functionParser.parseFunction(node, baseMetadata, executionContext);
                    outerProjectionFunctions.add(func);
                    innerProjectionFunctions.add(func);
                    if (node.type != 7) {
                        m = new TableColumnMetadata(Chars.toString(column.getName()), func.getType(), false, 0, func instanceof SymbolFunction && ((SymbolFunction)func).isSymbolTableStatic(), func.getMetadata());
                        if (func instanceof GroupByFunction) {
                            projectionFunctionFlags.add(2);
                        } else {
                            projectionFunctionFlags.add(1);
                        }
                    } else {
                        projectionFunctionFlags.add(0);
                    }
                } else {
                    outerProjectionFunctions.add(null);
                    projectionFunctionFlags.add(0);
                    if (projectionMetadata.getTimestampIndex() == -1) {
                        projectionMetadata.setTimestampIndex(i);
                    }
                }
                if (m == null) {
                    m = column.getAlias() == null ? baseMetadata.getColumnMetadata(index) : new TableColumnMetadata(Chars.toString(column.getAlias()), baseMetadata.getColumnType(index), baseMetadata.isColumnIndexed(index), baseMetadata.getIndexValueBlockCapacity(index), baseMetadata.isSymbolTableStatic(index), baseMetadata.getMetadata(index));
                }
                projectionMetadata.add(m);
                outPriorityMetadata.add(m);
            }
            n = columns.size();
            for (i = 0; i < n; ++i) {
                column = columns.getQuick(i);
                node = column.getAst();
                if (node.type != 7) {
                    Function function = outerProjectionFunctions.getQuick(i);
                    if (function instanceof GroupByFunction) {
                        GroupByFunction func = (GroupByFunction)function;
                        outGroupByFunctions.add(func);
                        outGroupByFunctionPositions.add(node.position);
                        if (fillCount > 0) {
                            int funcIndex = outGroupByFunctions.size();
                            int sampleByFlags = func.getSampleByFlags();
                            ExpressionNode fillNode = sampleByFill.getQuick(Math.min(funcIndex, fillCount - 1));
                            if (validateFill) {
                                if (SqlKeywords.isNullKeyword(fillNode.token) && (sampleByFlags & 0x10) == 0) {
                                    throw SqlException.$(node.position, "support for NULL fill is not yet implemented [function=").put(node).put(", class=").put(func.getClass().getName()).put(']');
                                }
                                if (SqlKeywords.isPrevKeyword(fillNode.token) && (sampleByFlags & 2) == 0) {
                                    throw SqlException.$(node.position, "support for PREV fill is not yet implemented [function=").put(node).put(", class=").put(func.getClass().getName()).put(']');
                                }
                                if (SqlKeywords.isLinearKeyword(fillNode.token) && (sampleByFlags & 4) == 0) {
                                    throw SqlException.$(node.position, "support for LINEAR fill is not yet implemented [function=").put(node).put(", class=").put(func.getClass().getName()).put(']');
                                }
                                if (SqlKeywords.isNoneKeyword(fillNode.token) && (sampleByFlags & 8) == 0) {
                                    throw SqlException.$(node.position, "support for NONE fill is not yet implemented [function=").put(node).put(", class=").put(func.getClass().getName()).put(']');
                                }
                                if ((sampleByFlags & 1) == 0) {
                                    throw SqlException.$(node.position, "support for VALUE fill is not yet implemented [function=").put(node).put(", class=").put(func.getClass().getName()).put(']');
                                }
                            }
                        }
                        func.initValueTypes(outValueTypes);
                    }
                } else {
                    int index = baseMetadata.getColumnIndexQuiet(node.token);
                    if (index == -1) {
                        throw SqlException.invalidColumn(node.position, node.token);
                    }
                    if ((index != timestampIndex || timestampUnimportant) && lastIndex != index) {
                        ++columnKeyCount;
                        lastIndex = index;
                    }
                }
                projectionFunctionPositions.add(node.position);
            }
            int keyColumnIndex = valueCount = outValueTypes.getColumnCount();
            int functionKeyColumnIndex = valueCount + columnKeyCount;
            int inferredKeyColumnCount = 0;
            lastIndex = -1;
            int n2 = columns.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                QueryColumn column2 = columns.getQuick(i2);
                ExpressionNode node2 = column2.getAst();
                if (node2.type == 7) {
                    int index = baseMetadata.getColumnIndexQuiet(node2.token);
                    int type = baseMetadata.getColumnType(index);
                    if (index != timestampIndex || timestampUnimportant) {
                        if (lastIndex != index) {
                            outColumnFilter.add(index + 1);
                            outKeyTypes.add(keyColumnIndex - valueCount, type);
                            ++keyColumnIndex;
                            lastIndex = index;
                        }
                        outerProjectionFunctions.set(i2, GroupByUtils.createColumnFunction(baseMetadata, keyColumnIndex, type, index));
                    }
                    ++inferredKeyColumnCount;
                    continue;
                }
                Function func = outerProjectionFunctions.getQuick(i2);
                if (func instanceof GroupByFunction) continue;
                Function columnRefFunc = GroupByUtils.createColumnFunction(null, ++functionKeyColumnIndex, func.getType(), -1);
                outKeyTypes.add(functionKeyColumnIndex - valueCount - 1, columnRefFunc.getType());
                if (func.getType() == 12 && columnRefFunc.getType() == 11) {
                    columnRefFunc = new CastStrToSymbolFunctionFactory.Func(columnRefFunc);
                }
                outerProjectionFunctions.set(i2, columnRefFunc);
                ++inferredKeyColumnCount;
            }
            GroupByUtils.validateGroupByColumns(sqlNodeStack, model, inferredKeyColumnCount);
        }
        catch (Throwable e) {
            Misc.freeObjListAndClear(outerProjectionFunctions);
            throw e;
        }
    }

    public static Function createColumnFunction(@Nullable RecordMetadata metadata, int keyColumnIndex, int type, int index) {
        Function func;
        switch (ColumnType.tagOf(type)) {
            case 1: {
                func = BooleanColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 2: {
                func = ByteColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 3: {
                func = ShortColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 4: {
                func = new CharColumn(keyColumnIndex - 1);
                break;
            }
            case 5: {
                func = IntColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 25: {
                func = new IPv4Column(keyColumnIndex - 1);
                break;
            }
            case 6: {
                func = LongColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 9: {
                func = FloatColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 10: {
                func = DoubleColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 11: {
                func = new StrColumn(keyColumnIndex - 1);
                break;
            }
            case 26: {
                func = new VarcharColumn(keyColumnIndex - 1);
                break;
            }
            case 12: {
                if (metadata != null) {
                    func = new MapSymbolColumn(keyColumnIndex - 1, index, metadata.isSymbolTableStatic(index));
                    break;
                }
                func = new StrColumn(keyColumnIndex - 1);
                break;
            }
            case 7: {
                func = DateColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 8: {
                func = TimestampColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 13: {
                func = Long256Column.newInstance(keyColumnIndex - 1);
                break;
            }
            case 14: {
                func = GeoByteColumn.newInstance(keyColumnIndex - 1, type);
                break;
            }
            case 15: {
                func = GeoShortColumn.newInstance(keyColumnIndex - 1, type);
                break;
            }
            case 16: {
                func = GeoIntColumn.newInstance(keyColumnIndex - 1, type);
                break;
            }
            case 17: {
                func = GeoLongColumn.newInstance(keyColumnIndex - 1, type);
                break;
            }
            case 24: {
                func = Long128Column.newInstance(keyColumnIndex - 1);
                break;
            }
            case 19: {
                func = UuidColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 32: {
                func = IntervalColumn.newInstance(keyColumnIndex - 1);
                break;
            }
            case 27: {
                func = new ArrayColumn(keyColumnIndex - 1, type);
                break;
            }
            default: {
                func = BinColumn.newInstance(keyColumnIndex - 1);
            }
        }
        return func;
    }

    public static boolean isEarlyExitSupported(ObjList<GroupByFunction> functions) {
        int n = functions.size();
        for (int i = 0; i < n; ++i) {
            if (functions.getQuick(i).isEarlyExitSupported()) continue;
            return false;
        }
        return true;
    }

    public static boolean isParallelismSupported(ObjList<GroupByFunction> functions) {
        int n = functions.size();
        for (int i = 0; i < n; ++i) {
            if (functions.getQuick(i).supportsParallelism()) continue;
            return false;
        }
        return true;
    }

    public static void prepareWorkerGroupByFunctions(@NotNull QueryModel model, @NotNull RecordMetadata metadata, @NotNull FunctionParser functionParser, @NotNull SqlExecutionContext executionContext, @NotNull ObjList<GroupByFunction> groupByFunctions, @NotNull ObjList<GroupByFunction> workerGroupByFunctions) throws SqlException {
        int i;
        ObjList<QueryColumn> columns = model.getColumns();
        int n = columns.size();
        for (i = 0; i < n; ++i) {
            QueryColumn column = columns.getQuick(i);
            ExpressionNode node = column.getAst();
            if (node.type == 7) continue;
            Function function = functionParser.parseFunction(node, metadata, executionContext);
            if (function instanceof GroupByFunction) {
                GroupByFunction func = (GroupByFunction)function;
                workerGroupByFunctions.add(func);
                continue;
            }
            Misc.free(function);
        }
        assert (groupByFunctions.size() == workerGroupByFunctions.size());
        n = groupByFunctions.size();
        for (i = 0; i < n; ++i) {
            GroupByFunction workerGroupByFunction = workerGroupByFunctions.getQuick(i);
            GroupByFunction groupByFunction = groupByFunctions.getQuick(i);
            workerGroupByFunction.initValueIndex(groupByFunction.getValueIndex());
        }
    }

    public static void setAllocator(ObjList<GroupByFunction> functions, GroupByAllocator allocator) {
        int n = functions.size();
        for (int i = 0; i < n; ++i) {
            functions.getQuick(i).setAllocator(allocator);
        }
    }

    public static void toTop(ObjList<? extends Function> args) {
        int n = args.size();
        for (int i = 0; i < n; ++i) {
            args.getQuick(i).toTop();
        }
    }

    public static void validateGroupByColumns(@NotNull ArrayDeque<ExpressionNode> sqlNodeStack, @NotNull QueryModel model, int inferredKeyColumnCount) throws SqlException {
        QueryModel chooseModel;
        ObjList<ExpressionNode> groupByColumns = model.getGroupBy();
        int explicitKeyColumnCount = groupByColumns.size();
        if (explicitKeyColumnCount == 0) {
            return;
        }
        for (chooseModel = model; chooseModel != null && chooseModel.getSelectModelType() != 1 && chooseModel.getSelectModelType() != 0; chooseModel = chooseModel.getNestedModel()) {
        }
        block7: for (int i = 0; i < explicitKeyColumnCount; ++i) {
            ExpressionNode key = groupByColumns.getQuick(i);
            switch (key.type) {
                case 7: {
                    int dotIndex = Chars.indexOfLastUnquoted(key.token, '.');
                    if (dotIndex > -1) {
                        int aliasIndex = model.getModelAliasIndex(key.token, 0, dotIndex);
                        if (aliasIndex > -1) {
                            int refColumn = model.getAliasToColumnMap().keyIndex(key.token);
                            if (refColumn > -1) {
                                refColumn = model.getAliasToColumnMap().keyIndex(key.token, dotIndex + 1, key.token.length());
                            }
                            if (refColumn <= -1) continue block7;
                            throw SqlException.$(key.position, "group by column does not match any key column is select statement");
                        }
                        if (chooseModel != null && chooseModel.getColumnNameToAliasMap().keyIndex(key.token) < 0) continue block7;
                        throw SqlException.$(key.position, "invalid column reference");
                    }
                    int refColumn = model.getAliasToColumnMap().keyIndex(key.token);
                    if (refColumn > -1) {
                        throw SqlException.$(key.position, "group by column does not match any key column is select statement");
                    }
                    QueryColumn qc = model.getAliasToColumnMap().valueAt(refColumn);
                    if (qc.getAst().type == 7 || qc.getAst().type == 4 || qc.getAst().type == 6 || qc.getAst().type == 9) continue block7;
                    throw SqlException.$(key.position, "group by column references aggregate expression");
                }
                case 3: {
                    throw SqlException.$(key.position, "bind variable is not allowed here");
                }
                case 6: 
                case 9: {
                    ObjList<QueryColumn> availableColumns = model.getBottomUpColumns();
                    boolean invalid = true;
                    int n = availableColumns.size();
                    for (int j = 0; j < n; ++j) {
                        QueryColumn qc = availableColumns.getQuick(j);
                        if (qc.getAst().type == key.type) {
                            if (!ExpressionNode.compareNodesGroupBy(key, qc.getAst(), chooseModel)) continue;
                            invalid = false;
                            break;
                        }
                        if (qc.getAst().type != 7 || !GroupByUtils.compareNodesGroupByFunctionKey(sqlNodeStack, chooseModel, key, qc.getAst())) continue;
                        invalid = false;
                        break;
                    }
                    if (!invalid) continue block7;
                    throw SqlException.$(key.position, "group by expression does not match anything select in statement");
                }
                case 4: {
                    continue block7;
                }
                default: {
                    throw SqlException.$(key.position, "unsupported type of expression");
                }
            }
        }
        if (explicitKeyColumnCount < inferredKeyColumnCount) {
            throw SqlException.$(model.getModelPosition(), "not enough columns in group by");
        }
    }

    private static boolean compareNodesGroupByFunctionKey(ArrayDeque<ExpressionNode> sqlNodeStack, QueryModel chooseModel, ExpressionNode functionKey, ExpressionNode arg) {
        sqlNodeStack.clear();
        while (!sqlNodeStack.isEmpty() || functionKey != null) {
            if (functionKey != null) {
                if (functionKey.paramCount < 3) {
                    if (functionKey.rhs != null) {
                        if (ExpressionNode.compareNodesGroupBy(functionKey.rhs, arg, chooseModel)) {
                            return true;
                        }
                        sqlNodeStack.push(functionKey.rhs);
                    }
                    if (functionKey.lhs != null && ExpressionNode.compareNodesGroupBy(functionKey.lhs, arg, chooseModel)) {
                        return true;
                    }
                    functionKey = functionKey.lhs;
                    continue;
                }
                int k = functionKey.paramCount;
                for (int i = 1; i < k; ++i) {
                    ExpressionNode e = functionKey.args.getQuick(i);
                    if (ExpressionNode.compareNodesGroupBy(e, arg, chooseModel)) {
                        return true;
                    }
                    sqlNodeStack.push(e);
                }
                ExpressionNode e = functionKey.args.getQuick(0);
                if (ExpressionNode.compareNodesGroupBy(e, arg, chooseModel)) {
                    return true;
                }
                functionKey = e;
                continue;
            }
            functionKey = sqlNodeStack.poll();
        }
        return false;
    }
}

