/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.engine.groupby.GroupByAllocator;
import io.questdb.std.Hash;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class GroupByLong128HashSet {
    private static final long HEADER_SIZE = 16L;
    private static final int MIN_INITIAL_CAPACITY = 2;
    private static final long SIZE_LIMIT_OFFSET = 8L;
    private static final long SIZE_OFFSET = 4L;
    private final int initialCapacity;
    private final double loadFactor;
    private final long noKeyValue;
    private GroupByAllocator allocator;
    private long mask;
    private long ptr;

    public GroupByLong128HashSet(int initialCapacity, double loadFactor, long noKeyValue) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        this.initialCapacity = Numbers.ceilPow2((int)((double)Math.max(initialCapacity, 2) / loadFactor));
        this.loadFactor = loadFactor;
        this.noKeyValue = noKeyValue;
    }

    public boolean add(long lo, long hi) {
        long index = this.keyIndex(lo, hi);
        if (index < 0L) {
            return false;
        }
        this.addAt(index, lo, hi);
        return true;
    }

    public void addAt(long index, long lo, long hi) {
        this.setKeyAt(index, lo, hi);
        int size = this.size();
        int sizeLimit = this.sizeLimit();
        Unsafe.getUnsafe().putInt(this.ptr + 4L, ++size);
        if (size >= sizeLimit) {
            this.rehash(this.capacity() << 1, sizeLimit << 1);
        }
    }

    public int capacity() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr) : 0;
    }

    public long keyAddrAt(long index) {
        return this.ptr + 16L + 16L * index;
    }

    public long keyIndex(long lo, long hi) {
        long hashCode = Hash.hashLong128_64(lo, hi);
        long index = hashCode & this.mask;
        long keyAddr = this.keyAddrAt(index);
        long loKey = Unsafe.getUnsafe().getLong(keyAddr);
        long hiKey = Unsafe.getUnsafe().getLong(keyAddr + 8L);
        if (loKey == this.noKeyValue && hiKey == this.noKeyValue) {
            return index;
        }
        if (loKey == lo && hiKey == hi) {
            return -index - 1L;
        }
        return this.probe(lo, hi, index);
    }

    public void merge(GroupByLong128HashSet srcSet) {
        long lim = srcSet.ptr + 16L + 16L * (long)srcSet.capacity();
        for (long p = srcSet.ptr + 16L; p < lim; p += 16L) {
            long index;
            long lo = Unsafe.getUnsafe().getLong(p);
            long hi = Unsafe.getUnsafe().getLong(p + 8L);
            if (lo == this.noKeyValue && hi == this.noKeyValue || (index = this.keyIndex(lo, hi)) < 0L) continue;
            this.addAt(index, lo, hi);
        }
    }

    public GroupByLong128HashSet of(long ptr) {
        if (ptr == 0L) {
            this.ptr = this.allocator.malloc(16L + 16L * (long)this.initialCapacity);
            this.zero(this.ptr, this.initialCapacity);
            Unsafe.getUnsafe().putInt(this.ptr, this.initialCapacity);
            Unsafe.getUnsafe().putInt(this.ptr + 4L, 0);
            Unsafe.getUnsafe().putInt(this.ptr + 8L, (int)((double)this.initialCapacity * this.loadFactor));
            this.mask = this.initialCapacity - 1;
        } else {
            this.ptr = ptr;
            this.mask = this.capacity() - 1;
        }
        return this;
    }

    public long ptr() {
        return this.ptr;
    }

    public void resetPtr() {
        this.ptr = 0L;
    }

    public void setAllocator(GroupByAllocator allocator) {
        this.allocator = allocator;
    }

    public int size() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 4L) : 0;
    }

    public int sizeLimit() {
        return this.ptr != 0L ? Unsafe.getUnsafe().getInt(this.ptr + 8L) : 0;
    }

    private long probe(long lo, long hi, long index) {
        long index0 = index;
        do {
            index = index + 1L & this.mask;
            long p = this.keyAddrAt(index);
            long loKey = Unsafe.getUnsafe().getLong(p);
            long hiKey = Unsafe.getUnsafe().getLong(p + 8L);
            if (loKey == this.noKeyValue && hiKey == this.noKeyValue) {
                return index;
            }
            if (loKey != lo || hiKey != hi) continue;
            return -index - 1L;
        } while (index != index0);
        throw CairoException.critical(0).put("corrupt long128 hash set");
    }

    private void rehash(int newCapacity, int newSizeLimit) {
        if (newCapacity < 0) {
            throw CairoException.nonCritical().put("long128 hash set capacity overflow");
        }
        int oldSize = this.size();
        int oldCapacity = this.capacity();
        long oldPtr = this.ptr;
        this.ptr = this.allocator.malloc(16L * (long)newCapacity + 16L);
        this.zero(this.ptr, newCapacity);
        Unsafe.getUnsafe().putInt(this.ptr, newCapacity);
        Unsafe.getUnsafe().putInt(this.ptr + 4L, oldSize);
        Unsafe.getUnsafe().putInt(this.ptr + 8L, newSizeLimit);
        this.mask = newCapacity - 1;
        long lim = oldPtr + 16L + 16L * (long)oldCapacity;
        for (long p = oldPtr + 16L; p < lim; p += 16L) {
            long lo = Unsafe.getUnsafe().getLong(p);
            long hi = Unsafe.getUnsafe().getLong(p + 8L);
            if (lo == this.noKeyValue && hi == this.noKeyValue) continue;
            long index = this.keyIndex(lo, hi);
            this.setKeyAt(index, lo, hi);
        }
        this.allocator.free(oldPtr, 16L + 16L * (long)oldCapacity);
    }

    private void setKeyAt(long index, long lo, long hi) {
        long p = this.keyAddrAt(index);
        Unsafe.getUnsafe().putLong(p, lo);
        Unsafe.getUnsafe().putLong(p + 8L, hi);
    }

    private void zero(long ptr, int cap) {
        if (this.noKeyValue == 0L) {
            Vect.memset(ptr + 16L, 16L * (long)cap, 0);
        } else {
            long lim = ptr + 16L + 16L * (long)cap;
            for (long p = ptr + 16L; p < lim; p += 16L) {
                Unsafe.getUnsafe().putLong(p, this.noKeyValue);
                Unsafe.getUnsafe().putLong(p + 8L, this.noKeyValue);
            }
        }
    }
}

