/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.BasePartitionedWindowFunction;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.functions.window.WindowDoubleFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public class LastValueDoubleWindowFunctionFactory
extends AbstractWindowFunctionFactory {
    public static final ArrayColumnTypes LAST_NOT_NULL_VALUE_PARTITION_ROWS_COLUMN_TYPES;
    public static final ArrayColumnTypes LAST_VALUE_COLUMN_TYPES;
    public static final ArrayColumnTypes LAST_VALUE_PARTITION_RANGE_COLUMN_TYPES;
    public static final ArrayColumnTypes LAST_VALUE_PARTITION_ROWS_COLUMN_TYPES;
    public static final String NAME = "last_value";
    private static final String SIGNATURE = "last_value(D)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        windowContext.validate(position, this.supportNullsDesc());
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (rowsHi < rowsLo) {
            return new AbstractWindowFunctionFactory.DoubleNullFunction(args.get(0), NAME, rowsLo, rowsHi, windowContext.getFramingMode() == 1, windowContext.getPartitionByRecord());
        }
        return windowContext.isIgnoreNulls() ? this.generateIgnoreNullsFunction(position, args, configuration, windowContext) : this.generateRespectNullsFunction(position, args, configuration, windowContext);
    }

    private Function generateIgnoreNullsFunction(int position, ObjList<Function> args, CairoConfiguration configuration, WindowContext windowContext) throws SqlException {
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_COLUMN_TYPES);
                    return new LastNotNullValueOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_COLUMN_TYPES);
                    return new LastNotNullValueOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_PARTITION_RANGE_COLUMN_TYPES);
                int initialBufferSize = configuration.getSqlWindowInitialRangeBufferSize();
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new LastNotNullValueOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, initialBufferSize, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_COLUMN_TYPES);
                    return new LastNotNullValueOverUnboundedPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new LastNotNullValueOverCurrentRowFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_COLUMN_TYPES);
                    return new LastNotNullValueOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_NOT_NULL_VALUE_PARTITION_ROWS_COLUMN_TYPES);
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new LastNotNullValueOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem);
            }
        } else {
            if (framingMode == 1) {
                if (!windowContext.isOrdered() && windowContext.isDefaultFrame()) {
                    return new LastNotNullValueOverWholeResultSetFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new LastNotNullOverUnboundedRowsFrameFunction(args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                return new LastNotNullValueOverRangeFrameFunction(rowsLo, rowsHi, args.get(0), configuration, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == 0L) {
                    return new LastNotNullOverUnboundedRowsFrameFunction(args.get(0));
                }
                if (rowsLo == 0L && rowsLo == rowsHi) {
                    return new LastNotNullValueOverCurrentRowFunction(args.get(0));
                }
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    return new LastNotNullValueOverWholeResultSetFunction(args.get(0));
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new LastNotNullValueOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    private Function generateRespectNullsFunction(int position, ObjList<Function> args, CairoConfiguration configuration, WindowContext windowContext) throws SqlException {
        int framingMode = windowContext.getFramingMode();
        RecordSink partitionBySink = windowContext.getPartitionBySink();
        ColumnTypes partitionByKeyTypes = windowContext.getPartitionByKeyTypes();
        VirtualRecord partitionByRecord = windowContext.getPartitionByRecord();
        long rowsLo = windowContext.getRowsLo();
        long rowsHi = windowContext.getRowsHi();
        if (partitionByRecord != null) {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_COLUMN_TYPES);
                    return new LastValueOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsHi == 0L) {
                    if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                        throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                    }
                    return new LastValueIncludeCurrentPartitionRowsFrameFunction(rowsLo, true, partitionByRecord, partitionBySink, args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_PARTITION_RANGE_COLUMN_TYPES);
                int initialBufferSize = configuration.getSqlWindowInitialRangeBufferSize();
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new LastValueOverPartitionRangeFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem, initialBufferSize, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_COLUMN_TYPES);
                    return new LastValueOverPartitionFunction(map, partitionByRecord, partitionBySink, args.get(0));
                }
                if (rowsHi == 0L) {
                    return new LastValueIncludeCurrentPartitionRowsFrameFunction(rowsLo, false, partitionByRecord, partitionBySink, args.get(0));
                }
                Map map = MapFactory.createUnorderedMap(configuration, partitionByKeyTypes, LAST_VALUE_PARTITION_ROWS_COLUMN_TYPES);
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new LastValueOverPartitionRowsFrameFunction(map, partitionByRecord, partitionBySink, rowsLo, rowsHi, args.get(0), mem);
            }
        } else {
            if (framingMode == 1) {
                if (windowContext.isDefaultFrame() && (!windowContext.isOrdered() || windowContext.getRowsHi() == Long.MAX_VALUE)) {
                    return new LastValueOverWholeResultSetFunction(args.get(0));
                }
                if (rowsHi == 0L) {
                    if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                        throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                    }
                    return new LastValueIncludeCurrentFrameFunction(rowsLo, true, args.get(0));
                }
                if (windowContext.isOrdered() && !windowContext.isOrderedByDesignatedTimestamp()) {
                    throw SqlException.$(windowContext.getOrderByPos(), "RANGE is supported only for queries ordered by designated timestamp");
                }
                int timestampIndex = windowContext.getTimestampIndex();
                return new LastValueOverRangeFrameFunction(rowsLo, rowsHi, args.get(0), configuration, timestampIndex);
            }
            if (framingMode == 2) {
                if (rowsLo == Long.MIN_VALUE && rowsHi == Long.MAX_VALUE) {
                    return new LastValueOverWholeResultSetFunction(args.get(0));
                }
                if (rowsHi == 0L) {
                    return new LastValueIncludeCurrentFrameFunction(rowsLo, false, args.get(0));
                }
                MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
                return new LastValueOverRowsFrameFunction(args.get(0), rowsLo, rowsHi, mem);
            }
        }
        throw SqlException.$(position, "function not implemented for given window parameters");
    }

    @Override
    protected boolean supportNullsDesc() {
        return true;
    }

    static {
        LAST_VALUE_COLUMN_TYPES = new ArrayColumnTypes();
        LAST_VALUE_COLUMN_TYPES.add(10);
        LAST_VALUE_PARTITION_ROWS_COLUMN_TYPES = new ArrayColumnTypes();
        LAST_VALUE_PARTITION_ROWS_COLUMN_TYPES.add(6);
        LAST_VALUE_PARTITION_ROWS_COLUMN_TYPES.add(6);
        LAST_VALUE_PARTITION_ROWS_COLUMN_TYPES.add(6);
        LAST_VALUE_PARTITION_RANGE_COLUMN_TYPES = new ArrayColumnTypes();
        LAST_VALUE_PARTITION_RANGE_COLUMN_TYPES.add(6);
        LAST_VALUE_PARTITION_RANGE_COLUMN_TYPES.add(6);
        LAST_VALUE_PARTITION_RANGE_COLUMN_TYPES.add(6);
        LAST_VALUE_PARTITION_RANGE_COLUMN_TYPES.add(6);
        LAST_NOT_NULL_VALUE_PARTITION_ROWS_COLUMN_TYPES = new ArrayColumnTypes();
        LAST_NOT_NULL_VALUE_PARTITION_ROWS_COLUMN_TYPES.add(10);
        LAST_NOT_NULL_VALUE_PARTITION_ROWS_COLUMN_TYPES.add(6);
        LAST_NOT_NULL_VALUE_PARTITION_ROWS_COLUMN_TYPES.add(6);
    }

    static class LastNotNullValueOverPartitionFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        public LastNotNullValueOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public WindowFunction.Pass1ScanDirection getPass1ScanDirection() {
            return WindowFunction.Pass1ScanDirection.BACKWARD;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            if (key.findValue() == null && Double.isFinite(d = this.arg.getDouble(record))) {
                MapValue value = key.createValue();
                value.putDouble(0, d);
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.findValue();
            double val = value != null ? value.getDouble(0) : Double.NaN;
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), val);
        }
    }

    public static class LastNotNullValueOverUnboundedPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private double value = Double.NaN;

        public LastNotNullValueOverUnboundedPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public void computeNext(Record record) {
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            double d = this.arg.getDouble(record);
            if (mapValue.isNew()) {
                mapValue.putDouble(0, d);
                this.value = d;
            } else if (Numbers.isFinite(d)) {
                mapValue.putDouble(0, d);
                this.value = d;
            } else {
                this.value = mapValue.getDouble(0);
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(") ignore nulls");
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between unbounded preceding and current row)");
        }
    }

    public static class LastNotNullValueOverPartitionRangeFrameFunction
    extends LastValueOverPartitionRangeFrameFunction {
        private final boolean frameIncludesCurrentValue;

        public LastNotNullValueOverPartitionRangeFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rangeLo, long rangeHi, Function arg, MemoryARW memory, int initialBufferSize, int timestampIdx) {
            super(map, partitionByRecord, partitionBySink, rangeLo, rangeHi, arg, memory, initialBufferSize, timestampIdx);
            this.frameIncludesCurrentValue = rangeHi == 0L;
        }

        @Override
        public void computeNext(Record record) {
            long firstIdx;
            long startOffset;
            long capacity;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long size = 0L;
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            if (mapValue.isNew()) {
                capacity = this.initialBufferSize;
                startOffset = this.memory.appendAddressFor(capacity * 16L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
                if (Numbers.isFinite(d)) {
                    this.memory.putLong(startOffset, timestamp);
                    this.memory.putDouble(startOffset + 8L, d);
                    size = 1L;
                    this.lastValue = this.frameIncludesCurrentValue ? d : Double.NaN;
                } else {
                    this.lastValue = Double.NaN;
                }
            } else {
                long idx;
                long ts;
                startOffset = mapValue.getLong(0);
                size = mapValue.getLong(1);
                capacity = mapValue.getLong(2);
                long newFirstIdx = firstIdx = mapValue.getLong(3);
                if (this.frameLoBounded) {
                    long idx2;
                    long ts2;
                    long n = size;
                    for (long i = 0L; i < n && Math.abs(timestamp - (ts2 = this.memory.getLong(startOffset + (idx2 = (firstIdx + i) % capacity) * 16L))) > this.maxDiff; ++i) {
                        newFirstIdx = (idx2 + 1L) % capacity;
                        --size;
                    }
                }
                firstIdx = newFirstIdx;
                if (Numbers.isFinite(d)) {
                    if (size == capacity) {
                        this.memoryDesc.reset(capacity, startOffset, size, firstIdx, this.freeList);
                        AbstractWindowFunctionFactory.expandRingBuffer(this.memory, this.memoryDesc, 16);
                        capacity = this.memoryDesc.capacity;
                        startOffset = this.memoryDesc.startOffset;
                        firstIdx = this.memoryDesc.firstIdx;
                    }
                    this.memory.putLong(startOffset + (firstIdx + size) % capacity * 16L, timestamp);
                    this.memory.putDouble(startOffset + (firstIdx + size) % capacity * 16L + 8L, d);
                    ++size;
                }
                long lastIndex = -1L;
                long n = size;
                for (long i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 16L))) >= this.minDiff; ++i) {
                    lastIndex = (int)(idx % capacity);
                    --size;
                }
                if (lastIndex != -1L) {
                    firstIdx = lastIndex;
                    ++size;
                }
                this.lastValue = lastIndex != -1L && size != 0L ? this.memory.getDouble(startOffset + firstIdx * 16L + 8L) : Double.NaN;
            }
            mapValue.putLong(0, startOffset);
            mapValue.putLong(1, size);
            mapValue.putLong(2, capacity);
            mapValue.putLong(3, firstIdx);
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }
    }

    static class LastNotNullValueOverCurrentRowFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private double value = Double.NaN;

        LastNotNullValueOverCurrentRowFunction(Function arg) {
            super(arg);
        }

        @Override
        public void computeNext(Record record) {
            this.value = this.arg.getDouble(record);
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }
    }

    public static class LastNotNullValueOverPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private final int bufferSize;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final int frameSize;
        private final MemoryARW memory;
        private double lastValue = Double.NaN;

        public LastNotNullValueOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi, Function arg, MemoryARW memory) {
            super(map, partitionByRecord, partitionBySink, arg);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.frameSize = 1;
                this.bufferSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.memory = memory;
        }

        @Override
        public void computeNext(Record record) {
            long startOffset;
            long loIdx;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            double d = this.arg.getDouble(record);
            if (value.isNew()) {
                loIdx = 0L;
                startOffset = this.memory.appendAddressFor((long)this.bufferSize * 8L) - this.memory.getPageAddress(0);
                this.lastValue = this.frameIncludesCurrentValue && Numbers.isFinite(d) ? d : Double.NaN;
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.memory.putDouble(startOffset + (long)i * 8L, Double.NaN);
                }
            } else {
                this.lastValue = value.getDouble(0);
                loIdx = value.getLong(1);
                startOffset = value.getLong(2);
                if (Numbers.isFinite(d) && this.frameIncludesCurrentValue) {
                    this.lastValue = d;
                } else if (this.frameLoBounded) {
                    double last = this.memory.getDouble(startOffset + (loIdx + (long)this.frameSize - 1L) % (long)this.bufferSize * 8L);
                    if (Numbers.isFinite(last)) {
                        this.lastValue = last;
                    } else if (!Numbers.isFinite(this.lastValue)) {
                        for (int i = this.frameSize - 2; 0 <= i; --i) {
                            double v = this.memory.getDouble(startOffset + (loIdx + (long)i) % (long)this.bufferSize * 8L);
                            if (!Numbers.isFinite(v)) continue;
                            this.lastValue = v;
                            break;
                        }
                    }
                } else {
                    double last = this.memory.getDouble(startOffset + loIdx % (long)this.bufferSize * 8L);
                    this.lastValue = Numbers.isFinite(last) ? last : value.getDouble(0);
                }
            }
            double nextLastValue = this.lastValue;
            if (this.frameLoBounded && this.memory.getDouble(startOffset + loIdx % (long)this.bufferSize * 8L) == this.lastValue) {
                nextLastValue = Double.NaN;
            }
            value.putDouble(0, nextLastValue);
            value.putLong(1, (loIdx + 1L) % (long)this.bufferSize);
            value.putLong(2, startOffset);
            this.memory.putDouble(startOffset + loIdx * 8L, d);
        }

        @Override
        public double getDouble(Record rec) {
            return this.lastValue;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.lastValue);
        }

        @Override
        public void reopen() {
            super.reopen();
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(") ignore nulls");
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between ");
            sink.val(this.bufferSize);
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize + 1 - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
            this.lastValue = Double.NaN;
        }
    }

    public static class LastNotNullValueOverWholeResultSetFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private boolean found;
        private double value = Double.NaN;

        public LastNotNullValueOverWholeResultSetFunction(Function arg) {
            super(arg);
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public WindowFunction.Pass1ScanDirection getPass1ScanDirection() {
            return WindowFunction.Pass1ScanDirection.BACKWARD;
        }

        @Override
        public int getPassCount() {
            return 2;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double d;
            if (!this.found && Numbers.isFinite(d = this.arg.getDouble(record))) {
                this.found = true;
                this.value = d;
            }
        }

        @Override
        public void pass2(Record record, long recordOffset, WindowSPI spi) {
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }

        @Override
        public void reset() {
            super.reset();
            this.value = Double.NaN;
            this.found = false;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.value = Double.NaN;
            this.found = false;
        }
    }

    public static class LastNotNullOverUnboundedRowsFrameFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private double lastValue = Double.NaN;

        public LastNotNullOverUnboundedRowsFrameFunction(Function arg) {
            super(arg);
        }

        @Override
        public void computeNext(Record record) {
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                this.lastValue = d;
            }
        }

        @Override
        public double getDouble(Record rec) {
            return this.lastValue;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.lastValue);
        }

        @Override
        public void reset() {
            super.reset();
            this.lastValue = Double.NaN;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(") ignore nulls");
            sink.val(" over (rows between unbounded preceding and current row)");
        }

        @Override
        public void toTop() {
            super.toTop();
            this.lastValue = Double.NaN;
        }
    }

    public static class LastNotNullValueOverRangeFrameFunction
    extends LastValueOverRangeFrameFunction {
        public LastNotNullValueOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, CairoConfiguration configuration, int timestampIdx) {
            super(rangeLo, rangeHi, arg, configuration, timestampIdx);
        }

        @Override
        public void computeNext(Record record) {
            long idx;
            long ts;
            long newFirstIdx = this.firstIdx;
            long timestamp = record.getTimestamp(this.timestampIndex);
            if (this.frameLoBounded) {
                long idx2;
                long ts2;
                long n = this.size;
                for (long i = 0L; i < n && Math.abs(timestamp - (ts2 = this.memory.getLong(this.startOffset + (idx2 = (this.firstIdx + i) % this.capacity) * 16L))) > this.maxDiff; ++i) {
                    newFirstIdx = (idx2 + 1L) % this.capacity;
                    --this.size;
                }
            }
            this.firstIdx = newFirstIdx;
            double d = this.arg.getDouble(record);
            if (Numbers.isFinite(d)) {
                if (this.size == this.capacity) {
                    long newAddress = this.memory.appendAddressFor(this.capacity * 16L);
                    long oldAddress = this.memory.getPageAddress(0) + this.startOffset;
                    if (this.firstIdx == 0L) {
                        Vect.memcpy(newAddress, oldAddress, this.size * 16L);
                    } else {
                        long firstPieceSize = (this.size - this.firstIdx) * 16L;
                        Vect.memcpy(newAddress, oldAddress + this.firstIdx * 16L, firstPieceSize);
                        Vect.memcpy(newAddress + firstPieceSize, oldAddress, (this.firstIdx + this.size) % this.size * 16L);
                        this.firstIdx = 0L;
                    }
                    this.startOffset = newAddress - this.memory.getPageAddress(0);
                    this.capacity <<= 1;
                }
                this.memory.putLong(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L, timestamp);
                this.memory.putDouble(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L + 8L, d);
                ++this.size;
            }
            long lastIndex = -1L;
            long n = this.size;
            for (long i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L))) >= this.minDiff; ++i) {
                lastIndex = (int)(idx % this.capacity);
                --this.size;
            }
            if (lastIndex != -1L) {
                this.firstIdx = lastIndex;
                ++this.size;
            }
            this.lastValue = lastIndex != -1L && this.size != 0L ? this.memory.getDouble(this.startOffset + this.firstIdx * 16L + 8L) : Double.NaN;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }
    }

    public static class LastNotNullValueOverRowsFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        private final MemoryARW buffer;
        private final int bufferSize;
        private final boolean frameIncludesCurrentValue;
        private final boolean frameLoBounded;
        private final int frameSize;
        private double cacheValue = Double.NaN;
        private double lastValue = Double.NaN;
        private int loIdx = 0;

        public LastNotNullValueOverRowsFrameFunction(Function arg, long rowsLo, long rowsHi, MemoryARW memory) {
            super(arg);
            assert (rowsLo != Long.MIN_VALUE || rowsHi != 0L);
            if (rowsLo > Long.MIN_VALUE) {
                this.frameSize = (int)(rowsHi - rowsLo + (long)(rowsHi < 0L ? 1 : 0));
                this.bufferSize = (int)Math.abs(rowsLo);
                this.frameLoBounded = true;
            } else {
                this.bufferSize = this.frameSize = (int)Math.abs(rowsHi);
                this.frameLoBounded = false;
            }
            this.frameIncludesCurrentValue = rowsHi == 0L;
            this.buffer = memory;
            this.initBuffer();
        }

        @Override
        public void close() {
            super.close();
            this.buffer.close();
        }

        @Override
        public void computeNext(Record record) {
            double d = this.arg.getDouble(record);
            this.lastValue = this.cacheValue;
            if (Numbers.isFinite(d) && this.frameIncludesCurrentValue) {
                this.lastValue = d;
            } else if (this.frameLoBounded) {
                double last = this.buffer.getDouble((long)(this.loIdx + this.frameSize - 1) % (long)this.bufferSize * 8L);
                if (Numbers.isFinite(last)) {
                    this.lastValue = last;
                } else if (!Numbers.isFinite(this.lastValue)) {
                    for (int i = this.frameSize - 2; 0 <= i; --i) {
                        double v = this.buffer.getDouble((long)(this.loIdx + i) % (long)this.bufferSize * 8L);
                        if (!Numbers.isFinite(v)) continue;
                        this.lastValue = v;
                        break;
                    }
                }
            } else {
                double last = this.buffer.getDouble((long)this.loIdx % (long)this.bufferSize * 8L);
                this.lastValue = Numbers.isFinite(last) ? last : this.cacheValue;
            }
            this.cacheValue = this.lastValue;
            if (this.frameLoBounded && this.buffer.getDouble((long)this.loIdx % (long)this.bufferSize * 8L) == this.lastValue) {
                this.cacheValue = Double.NaN;
            }
            this.buffer.putDouble((long)this.loIdx * 8L, d);
            this.loIdx = (this.loIdx + 1) % this.bufferSize;
        }

        @Override
        public double getDouble(Record rec) {
            return this.lastValue;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public boolean isIgnoreNulls() {
            return true;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.lastValue);
        }

        @Override
        public void reopen() {
            this.lastValue = Double.NaN;
            this.loIdx = 0;
            this.initBuffer();
        }

        @Override
        public void reset() {
            super.reset();
            this.buffer.close();
            this.lastValue = Double.NaN;
            this.cacheValue = Double.NaN;
            this.loIdx = 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(") ignore nulls");
            sink.val(" over (");
            sink.val(" rows between ");
            sink.val(this.bufferSize);
            sink.val(" preceding and ");
            if (this.frameIncludesCurrentValue) {
                sink.val("current row");
            } else {
                sink.val(this.bufferSize + 1 - this.frameSize).val(" preceding");
            }
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.lastValue = Double.NaN;
            this.cacheValue = Double.NaN;
            this.loIdx = 0;
            this.initBuffer();
        }

        private void initBuffer() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer.putDouble((long)i * 8L, Double.NaN);
            }
        }
    }

    static class LastValueOverPartitionFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        public LastValueOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(map, partitionByRecord, partitionBySink, arg);
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public WindowFunction.Pass1ScanDirection getPass1ScanDirection() {
            return WindowFunction.Pass1ScanDirection.BACKWARD;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            double val;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            if (value.isNew()) {
                double d = this.arg.getDouble(record);
                value.putDouble(0, d);
                val = d;
            } else {
                val = value.getDouble(0);
            }
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), val);
        }
    }

    public static class LastValueIncludeCurrentPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private final boolean isRange;
        private final long rowsLo;
        private double value = Double.NaN;

        public LastValueIncludeCurrentPartitionRowsFrameFunction(long rowsLo, boolean isRange, VirtualRecord partitionByRecord, RecordSink partitionBySink, Function arg) {
            super(null, partitionByRecord, partitionBySink, arg);
            this.isRange = isRange;
            this.rowsLo = rowsLo;
        }

        @Override
        public void computeNext(Record record) {
            this.value = this.arg.getDouble(record);
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            if (this.isRange) {
                sink.val(" range between ");
            } else {
                sink.val(" rows between ");
            }
            if (this.rowsLo == Long.MIN_VALUE) {
                sink.val("unbounded");
            } else {
                sink.val(Math.abs(this.rowsLo));
            }
            sink.val(" preceding and current row)");
        }
    }

    public static class LastValueOverPartitionRangeFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        protected static final int RECORD_SIZE = 16;
        protected final boolean frameLoBounded;
        protected final LongList freeList = new LongList();
        protected final int initialBufferSize;
        protected final long maxDiff;
        protected final MemoryARW memory;
        protected final AbstractWindowFunctionFactory.RingBufferDesc memoryDesc = new AbstractWindowFunctionFactory.RingBufferDesc();
        protected final long minDiff;
        protected final int timestampIndex;
        protected double lastValue = Double.NaN;

        public LastValueOverPartitionRangeFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rangeLo, long rangeHi, Function arg, MemoryARW memory, int initialBufferSize, int timestampIdx) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Math.abs(rangeHi);
            this.minDiff = Math.abs(rangeHi);
            this.memory = memory;
            this.initialBufferSize = initialBufferSize;
            this.timestampIndex = timestampIdx;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
            this.freeList.clear();
        }

        @Override
        public void computeNext(Record record) {
            long size;
            long firstIdx;
            long startOffset;
            long capacity;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            if (mapValue.isNew()) {
                capacity = this.initialBufferSize;
                startOffset = this.memory.appendAddressFor(capacity * 16L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
                this.memory.putLong(startOffset, timestamp);
                this.memory.putDouble(startOffset + 8L, d);
                size = 1L;
                this.lastValue = Double.NaN;
            } else {
                long idx;
                long ts;
                startOffset = mapValue.getLong(0);
                size = mapValue.getLong(1);
                capacity = mapValue.getLong(2);
                long newFirstIdx = firstIdx = mapValue.getLong(3);
                if (this.frameLoBounded) {
                    long idx2;
                    long ts2;
                    long n = size;
                    for (long i = 0L; i < n && Math.abs(timestamp - (ts2 = this.memory.getLong(startOffset + (idx2 = (firstIdx + i) % capacity) * 16L))) > this.maxDiff; ++i) {
                        newFirstIdx = (idx2 + 1L) % capacity;
                        --size;
                    }
                }
                firstIdx = newFirstIdx;
                long lastIndex = -1L;
                long n = size;
                for (long i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(startOffset + (idx = (firstIdx + i) % capacity) * 16L))) >= this.minDiff; ++i) {
                    lastIndex = (int)(idx % capacity);
                    --size;
                }
                if (lastIndex != -1L) {
                    firstIdx = lastIndex;
                    ++size;
                }
                this.lastValue = lastIndex != -1L && size != 0L ? this.memory.getDouble(startOffset + firstIdx * 16L + 8L) : Double.NaN;
                if (size == capacity) {
                    this.memoryDesc.reset(capacity, startOffset, size, firstIdx, this.freeList);
                    AbstractWindowFunctionFactory.expandRingBuffer(this.memory, this.memoryDesc, 16);
                    capacity = this.memoryDesc.capacity;
                    startOffset = this.memoryDesc.startOffset;
                    firstIdx = this.memoryDesc.firstIdx;
                }
                this.memory.putLong(startOffset + (firstIdx + size) % capacity * 16L, timestamp);
                this.memory.putDouble(startOffset + (firstIdx + size) % capacity * 16L + 8L, d);
                ++size;
            }
            mapValue.putLong(0, startOffset);
            mapValue.putLong(1, size);
            mapValue.putLong(2, capacity);
            mapValue.putLong(3, firstIdx);
        }

        @Override
        public double getDouble(Record rec) {
            return this.lastValue;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            super.reopen();
            this.lastValue = Double.NaN;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
            this.freeList.clear();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" range between ");
            if (!this.frameLoBounded) {
                sink.val("unbounded");
            } else {
                sink.val(this.maxDiff);
            }
            sink.val(" preceding and ");
            sink.val(this.minDiff).val(" preceding");
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
            this.freeList.clear();
            this.lastValue = Double.NaN;
        }
    }

    public static class LastValueOverPartitionRowsFrameFunction
    extends BasePartitionedWindowFunction
    implements WindowDoubleFunction {
        private final int bufferSize;
        private final MemoryARW memory;
        private final long rowLo;
        private double lastValue = Double.NaN;

        public LastValueOverPartitionRowsFrameFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, long rowsLo, long rowsHi, Function arg, MemoryARW memory) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.bufferSize = (int)Math.abs(rowsHi);
            this.rowLo = rowsLo;
            this.memory = memory;
        }

        @Override
        public void computeNext(Record record) {
            long startOffset;
            long loIdx;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue value = key.createValue();
            double d = this.arg.getDouble(record);
            if (value.isNew()) {
                loIdx = 0L;
                startOffset = this.memory.appendAddressFor((long)this.bufferSize * 8L) - this.memory.getPageAddress(0);
                value.putLong(1, startOffset);
                for (int i = 0; i < this.bufferSize; ++i) {
                    this.memory.putDouble(startOffset + (long)i * 8L, Double.NaN);
                }
            } else {
                loIdx = value.getLong(0);
                startOffset = value.getLong(1);
            }
            this.lastValue = this.memory.getDouble(startOffset + loIdx % (long)this.bufferSize * 8L);
            value.putLong(0, (loIdx + 1L) % (long)this.bufferSize);
            this.memory.putDouble(startOffset + loIdx % (long)this.bufferSize * 8L, d);
        }

        @Override
        public double getDouble(Record rec) {
            return this.lastValue;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.lastValue);
        }

        @Override
        public void reopen() {
            super.reopen();
            this.lastValue = Double.NaN;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(" rows between ");
            if (this.rowLo == Long.MAX_VALUE) {
                sink.val("unbounded");
            } else {
                sink.val(Math.abs(this.rowLo));
            }
            sink.val(" preceding and ");
            sink.val(this.bufferSize).val(" preceding");
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
            this.lastValue = Double.NaN;
        }
    }

    public static class LastValueOverWholeResultSetFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private boolean found;
        private double value = Double.NaN;

        public LastValueOverWholeResultSetFunction(Function arg) {
            super(arg);
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public WindowFunction.Pass1ScanDirection getPass1ScanDirection() {
            return WindowFunction.Pass1ScanDirection.BACKWARD;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            if (!this.found) {
                this.value = this.arg.getDouble(record);
                this.found = true;
            }
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }

        @Override
        public void reset() {
            super.reset();
            this.value = Double.NaN;
            this.found = false;
        }

        @Override
        public void toTop() {
            super.toTop();
            this.value = Double.NaN;
            this.found = false;
        }
    }

    public static class LastValueIncludeCurrentFrameFunction
    extends BaseWindowFunction
    implements WindowDoubleFunction {
        private final boolean isRange;
        private final long rowsLo;
        private double value = Double.NaN;

        public LastValueIncludeCurrentFrameFunction(long rowsLo, boolean isRange, Function arg) {
            super(arg);
            this.rowsLo = rowsLo;
            this.isRange = isRange;
        }

        @Override
        public void computeNext(Record record) {
            this.value = this.arg.getDouble(record);
        }

        @Override
        public double getDouble(Record rec) {
            return this.value;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.value);
        }

        @Override
        public void reset() {
            super.reset();
            this.value = Double.NaN;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            if (this.isRange) {
                sink.val("range between ");
            } else {
                sink.val("rows between ");
            }
            if (this.rowsLo == Long.MIN_VALUE) {
                sink.val("unbounded");
            } else {
                sink.val(Math.abs(this.rowsLo));
            }
            sink.val(" preceding and current row)");
        }

        @Override
        public void toTop() {
            super.toTop();
            this.value = Double.NaN;
        }
    }

    public static class LastValueOverRangeFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        protected static final int RECORD_SIZE = 16;
        protected final boolean frameLoBounded;
        protected final long initialCapacity;
        protected final long maxDiff;
        protected final MemoryARW memory;
        protected final long minDiff;
        protected final int timestampIndex;
        protected long capacity;
        protected long firstIdx;
        protected double lastValue = Double.NaN;
        protected long size;
        protected long startOffset;

        public LastValueOverRangeFrameFunction(long rangeLo, long rangeHi, Function arg, CairoConfiguration configuration, int timestampIdx) {
            super(arg);
            this.frameLoBounded = rangeLo != Long.MIN_VALUE;
            this.maxDiff = this.frameLoBounded ? Math.abs(rangeLo) : Math.abs(rangeHi);
            this.minDiff = Math.abs(rangeHi);
            this.timestampIndex = timestampIdx;
            this.capacity = this.initialCapacity = (long)(configuration.getSqlWindowStorePageSize() / 16);
            this.memory = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
        }

        @Override
        public void close() {
            super.close();
            this.memory.close();
        }

        @Override
        public void computeNext(Record record) {
            long idx;
            long ts;
            long timestamp = record.getTimestamp(this.timestampIndex);
            double d = this.arg.getDouble(record);
            long newFirstIdx = this.firstIdx;
            if (this.frameLoBounded) {
                long idx2;
                long ts2;
                long n = this.size;
                for (long i = 0L; i < n && Math.abs(timestamp - (ts2 = this.memory.getLong(this.startOffset + (idx2 = (this.firstIdx + i) % this.capacity) * 16L))) > this.maxDiff; ++i) {
                    newFirstIdx = (idx2 + 1L) % this.capacity;
                    --this.size;
                }
            }
            this.firstIdx = newFirstIdx;
            long lastIndex = -1L;
            long n = this.size;
            for (long i = 0L; i < n && Math.abs(timestamp - (ts = this.memory.getLong(this.startOffset + (idx = (this.firstIdx + i) % this.capacity) * 16L))) >= this.minDiff; ++i) {
                lastIndex = (int)(idx % this.capacity);
                --this.size;
            }
            if (lastIndex != -1L) {
                this.firstIdx = lastIndex;
                ++this.size;
            }
            this.lastValue = lastIndex != -1L && this.size != 0L ? this.memory.getDouble(this.startOffset + this.firstIdx * 16L + 8L) : Double.NaN;
            if (this.size == this.capacity) {
                long newAddress = this.memory.appendAddressFor(this.capacity * 16L);
                long oldAddress = this.memory.getPageAddress(0) + this.startOffset;
                if (this.firstIdx == 0L) {
                    Vect.memcpy(newAddress, oldAddress, this.size * 16L);
                } else {
                    long firstPieceSize = (this.size - this.firstIdx) * 16L;
                    Vect.memcpy(newAddress, oldAddress + this.firstIdx * 16L, firstPieceSize);
                    Vect.memcpy(newAddress + firstPieceSize, oldAddress, (this.firstIdx + this.size) % this.size * 16L);
                    this.firstIdx = 0L;
                }
                this.startOffset = newAddress - this.memory.getPageAddress(0);
                this.capacity <<= 1;
            }
            this.memory.putLong(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L, timestamp);
            this.memory.putDouble(this.startOffset + (this.firstIdx + this.size) % this.capacity * 16L + 8L, d);
            ++this.size;
        }

        @Override
        public double getDouble(Record rec) {
            return this.lastValue;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reopen() {
            this.lastValue = Double.NaN;
            this.capacity = this.initialCapacity;
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.size = 0L;
        }

        @Override
        public void reset() {
            super.reset();
            this.memory.close();
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("range between ");
            if (this.frameLoBounded) {
                sink.val(this.maxDiff);
            } else {
                sink.val("unbounded");
            }
            sink.val(" preceding and ");
            sink.val(this.minDiff).val(" preceding");
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.lastValue = Double.NaN;
            this.capacity = this.initialCapacity;
            this.memory.truncate();
            this.startOffset = this.memory.appendAddressFor(this.capacity * 16L) - this.memory.getPageAddress(0);
            this.firstIdx = 0L;
            this.size = 0L;
        }
    }

    public static class LastValueOverRowsFrameFunction
    extends BaseWindowFunction
    implements Reopenable,
    WindowDoubleFunction {
        private final MemoryARW buffer;
        private final int bufferSize;
        private final long rowsLo;
        private double lastValue = Double.NaN;
        private int loIdx = 0;

        public LastValueOverRowsFrameFunction(Function arg, long rowsLo, long rowsHi, MemoryARW memory) {
            super(arg);
            this.bufferSize = (int)Math.abs(rowsHi);
            this.buffer = memory;
            this.rowsLo = rowsLo;
            this.initBuffer();
        }

        @Override
        public void close() {
            super.close();
            this.buffer.close();
        }

        @Override
        public void computeNext(Record record) {
            this.lastValue = this.buffer.getDouble((long)this.loIdx * 8L);
            this.buffer.putDouble((long)this.loIdx * 8L, this.arg.getDouble(record));
            this.loIdx = (this.loIdx + 1) % this.bufferSize;
        }

        @Override
        public double getDouble(Record rec) {
            return this.lastValue;
        }

        @Override
        public String getName() {
            return LastValueDoubleWindowFunctionFactory.NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            this.computeNext(record);
            Unsafe.getUnsafe().putDouble(spi.getAddress(recordOffset, this.columnIndex), this.lastValue);
        }

        @Override
        public void reopen() {
            this.lastValue = Double.NaN;
            this.loIdx = 0;
            this.initBuffer();
        }

        @Override
        public void reset() {
            super.reset();
            this.buffer.close();
            this.lastValue = Double.NaN;
            this.loIdx = 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(')');
            if (this.isIgnoreNulls()) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val(" rows between ");
            if (this.rowsLo == Long.MIN_VALUE) {
                sink.val(" unbounded preceding and ");
            } else {
                sink.val(Math.abs(this.rowsLo));
                sink.val(" preceding between and ");
            }
            sink.val(this.bufferSize).val(" preceding");
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.lastValue = Double.NaN;
            this.loIdx = 0;
            this.initBuffer();
        }

        private void initBuffer() {
            for (int i = 0; i < this.bufferSize; ++i) {
                this.buffer.putDouble((long)i * 8L, Double.NaN);
            }
        }
    }
}

