/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.RankFunctionFactory;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class DenseRankFunctionFactory
extends AbstractWindowFunctionFactory {
    public static final String NAME = "dense_rank";
    private static final String SIGNATURE = "dense_rank()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        if (windowContext.isEmpty()) {
            throw SqlException.emptyWindowContext(position);
        }
        if (windowContext.getNullsDescPos() > 0) {
            throw SqlException.$(windowContext.getNullsDescPos(), "RESPECT/IGNORE NULLS is not supported for current window function");
        }
        if (windowContext.isOrdered()) {
            if (windowContext.getPartitionByRecord() != null) {
                return new RankFunctionFactory.RankOverPartitionFunction(windowContext.getPartitionByKeyTypes(), windowContext.getPartitionByRecord(), windowContext.getPartitionBySink(), configuration, true, NAME);
            }
            return new RankFunctionFactory.RankFunction(configuration, true, NAME);
        }
        return new RankFunctionFactory.RankNoOrderFunction(windowContext.getPartitionByRecord(), NAME);
    }
}

