/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.griffin.engine.functions.table.ReadParquetPageFrameRecordCursorFactory;
import io.questdb.griffin.engine.functions.table.ReadParquetRecordCursorFactory;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.str.Path;

public class ReadParquetFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(ReadParquetFunctionFactory.class);

    @Override
    public String getSignature() {
        return "read_parquet(s)";
    }

    @Override
    public boolean isCursor() {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPos, CairoConfiguration configuration, SqlExecutionContext context) throws SqlException {
        CharSequence filePath;
        try {
            filePath = args.getQuick(0).getStrA(null);
        }
        catch (CairoException e) {
            throw SqlException.$(argPos.getQuick(0), e.getFlyweightMessage());
        }
        try {
            Path path = Path.getThreadLocal2("");
            this.checkPathIsSafeToRead(path, filePath, argPos.getQuick(0), configuration);
            FilesFacade ff = configuration.getFilesFacade();
            long fd = TableUtils.openRO(ff, path.$(), LOG);
            long addr = 0L;
            long fileSize = 0L;
            try {
                GenericRecordMetadata metadata;
                PartitionDecoder decoder;
                block15: {
                    decoder = new PartitionDecoder();
                    try {
                        fileSize = ff.length(fd);
                        addr = TableUtils.mapRO(ff, fd, fileSize, 17);
                        decoder.of(addr, fileSize, 65);
                        metadata = new GenericRecordMetadata();
                        decoder.metadata().copyTo(metadata, true);
                        if (!context.isParallelReadParquetEnabled()) break block15;
                        CursorFunction cursorFunction = new CursorFunction(new ReadParquetPageFrameRecordCursorFactory(configuration, path, metadata));
                        decoder.close();
                        return cursorFunction;
                    }
                    catch (Throwable throwable) {
                        try {
                            decoder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                CursorFunction cursorFunction = new CursorFunction(new ReadParquetRecordCursorFactory(path, metadata, ff));
                decoder.close();
                return cursorFunction;
            }
            finally {
                ff.close(fd);
                ff.munmap(addr, fileSize, 17);
            }
        }
        catch (CairoException e) {
            throw SqlException.$(argPos.getQuick(0), "error reading parquet file ").put('[').put(e.getErrno()).put("]: ").put(e.getFlyweightMessage());
        }
        catch (Throwable e) {
            throw SqlException.$(argPos.getQuick(0), "failed to read parquet file: ").put(filePath).put(": ").put(e.getMessage());
        }
    }

    private void checkPathIsSafeToRead(Path path, CharSequence filePath, int position, CairoConfiguration config) throws SqlException {
        CharSequence sqlCopyInputRoot = config.getSqlCopyInputRoot();
        if (Chars.isBlank(sqlCopyInputRoot)) {
            throw SqlException.$(position, "parquet files can only be read from sql.copy.input.root, please add sql.copy.input.root=<path> to your configuration");
        }
        if (Chars.isBlank(filePath)) {
            throw SqlException.$(position, "parquet file path pattern is empty");
        }
        if (Chars.contains(filePath, "../") || Chars.contains(filePath, "..\\")) {
            throw SqlException.$(position, "relative path is not allowed");
        }
        if (filePath.length() > sqlCopyInputRoot.length() && (Chars.startsWith(filePath, sqlCopyInputRoot) || (Os.isWindows() || Os.isOSX()) && Chars.startsWithIgnoreCase(filePath, sqlCopyInputRoot)) && (sqlCopyInputRoot.charAt(sqlCopyInputRoot.length() - 1) == Files.SEPARATOR || filePath.charAt(sqlCopyInputRoot.length()) == Files.SEPARATOR || Os.isWindows() && filePath.charAt(sqlCopyInputRoot.length()) == '/')) {
            path.of(filePath);
            return;
        }
        path.of(sqlCopyInputRoot).concat(filePath);
    }
}

