/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.TernaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;

public class SplitPartFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "split_part(SSI)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function strFunc = args.getQuick(0);
        Function delimiterFunc = args.getQuick(1);
        Function indexFunc = args.getQuick(2);
        int indexPosition = argPositions.getQuick(2);
        if (indexFunc.isConstant()) {
            int index = indexFunc.getInt(null);
            if (index == Integer.MIN_VALUE) {
                return StrConstant.NULL;
            }
            if (index == 0) {
                throw SqlException.$(indexPosition, "field position must not be zero");
            }
            return new SplitPartConstIndexFunction(strFunc, delimiterFunc, indexFunc, indexPosition, index);
        }
        if (!indexFunc.isRuntimeConstant()) {
            throw SqlException.$(indexPosition, "index must be either a constant expression or a placeholder");
        }
        return new SplitPartFunction(strFunc, delimiterFunc, indexFunc, indexPosition);
    }

    private static void splitToSink(Utf16Sink sink, int index, CharSequence str, CharSequence delimiter) {
        int end;
        int start;
        if (index == 0) {
            return;
        }
        if (index > 0) {
            if (index == 1) {
                start = 0;
            } else {
                start = Chars.indexOf(str, 0, str.length(), delimiter, index - 1);
                if (start == -1) {
                    return;
                }
                start += delimiter.length();
            }
            end = Chars.indexOf(str, start, str.length(), delimiter);
            if (end == -1) {
                end = str.length();
            }
        } else {
            if (index == -1) {
                end = str.length();
            } else {
                end = Chars.indexOf(str, 0, str.length(), delimiter, index + 1);
                if (end == -1) {
                    return;
                }
            }
            start = Chars.indexOf(str, 0, end, delimiter, -1);
            start = start == -1 ? 0 : (start += delimiter.length());
        }
        sink.put(str, start, end);
    }

    private static class SplitPartConstIndexFunction
    extends AbstractSplitPartFunction {
        private final int index;

        public SplitPartConstIndexFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition, int index) {
            super(strFunc, delimiterFunc, indexFunc, indexPosition);
            this.index = index;
        }

        @Override
        int getIndex(Record rec) {
            return this.index;
        }
    }

    private static class SplitPartFunction
    extends AbstractSplitPartFunction
    implements TernaryFunction {
        public SplitPartFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition) {
            super(strFunc, delimiterFunc, indexFunc, indexPosition);
        }

        @Override
        int getIndex(Record rec) {
            return this.indexFunc.getInt(rec);
        }
    }

    private static abstract class AbstractSplitPartFunction
    extends StrFunction
    implements TernaryFunction {
        protected final Function delimiterFunc;
        protected final Function indexFunc;
        protected final Function strFunc;
        private final int indexPosition;
        private final StringSink sinkA = new StringSink();
        private final StringSink sinkB = new StringSink();

        public AbstractSplitPartFunction(Function strFunc, Function delimiterFunc, Function indexFunc, int indexPosition) {
            this.strFunc = strFunc;
            this.delimiterFunc = delimiterFunc;
            this.indexFunc = indexFunc;
            this.indexPosition = indexPosition;
        }

        @Override
        public final Function getCenter() {
            return this.delimiterFunc;
        }

        @Override
        public final Function getLeft() {
            return this.strFunc;
        }

        @Override
        public String getName() {
            return "split_part";
        }

        @Override
        public final Function getRight() {
            return this.indexFunc;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.getStrWithClear(rec, this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.getStrWithClear(rec, this.sinkB);
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            int index;
            TernaryFunction.super.init(symbolTableSource, executionContext);
            if (this.indexFunc.isRuntimeConstant() && (index = this.indexFunc.getInt(null)) == 0) {
                throw SqlException.$(this.indexPosition, "field position must not be zero");
            }
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private StringSink getStrWithClear(Record rec, StringSink sink) {
            sink.clear();
            CharSequence str = this.strFunc.getStrA(rec);
            CharSequence delimiter = this.delimiterFunc.getStrA(rec);
            int index = this.getIndex(rec);
            if (str == null || delimiter == null || index == Integer.MIN_VALUE) {
                return null;
            }
            SplitPartFunctionFactory.splitToSink(sink, index, str, delimiter);
            return sink;
        }

        abstract int getIndex(Record var1);
    }
}

