/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.str;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.griffin.engine.functions.constants.VarcharConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import io.questdb.std.str.Utf8s;
import org.jetbrains.annotations.Nullable;

public class LeftVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "left(\u00d8I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function varcharFunc = args.getQuick(0);
        Function countFunc = args.getQuick(1);
        if (countFunc.isConstant()) {
            int count = countFunc.getInt(null);
            if (count != Integer.MIN_VALUE) {
                return new ConstCountFunc(varcharFunc, count);
            }
            return VarcharConstant.NULL;
        }
        return new Func(varcharFunc, countFunc);
    }

    private static int getCharPos(int len, int count) {
        return count > -1 ? Math.max(0, Math.min(len, count)) : Math.max(0, len + count);
    }

    private static class ConstCountFunc
    extends VarcharFunction
    implements UnaryFunction {
        private final int count;
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();
        private final Function varcharFunc;

        public ConstCountFunc(Function varcharFunc, int count) {
            this.varcharFunc = varcharFunc;
            this.count = count;
        }

        @Override
        public Function getArg() {
            return this.varcharFunc;
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharA(Record rec) {
            return this.getVarchar0(rec, this.sinkA);
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharB(Record rec) {
            return this.getVarchar0(rec, this.sinkB);
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("left(").val(this.varcharFunc).val(',').val(this.count).val(')');
        }

        private int getCharPos(int len) {
            return LeftVarcharFunctionFactory.getCharPos(len, this.count);
        }

        @Nullable
        private Utf8StringSink getVarchar0(Record rec, Utf8StringSink sink) {
            Utf8Sequence value = this.varcharFunc.getVarcharA(rec);
            if (value != null) {
                int len = Utf8s.validateUtf8(value);
                if (len == -1) {
                    return null;
                }
                int charHi = this.getCharPos(len);
                sink.clear();
                Utf8s.strCpy(value, 0, charHi, sink);
                return sink;
            }
            return null;
        }
    }

    private static class Func
    extends VarcharFunction
    implements BinaryFunction {
        private final Function countFunc;
        private final Utf8StringSink sinkA = new Utf8StringSink();
        private final Utf8StringSink sinkB = new Utf8StringSink();
        private final Function varcharFunc;

        public Func(Function varcharFunc, Function countFunc) {
            this.varcharFunc = varcharFunc;
            this.countFunc = countFunc;
        }

        @Override
        public Function getLeft() {
            return this.varcharFunc;
        }

        @Override
        public String getName() {
            return "left";
        }

        @Override
        public Function getRight() {
            return this.countFunc;
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharA(Record rec) {
            return this.getVarchar0(rec, this.sinkA);
        }

        @Override
        @Nullable
        public Utf8Sequence getVarcharB(Record rec) {
            return this.getVarchar0(rec, this.sinkB);
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Nullable
        private Utf8StringSink getVarchar0(Record rec, Utf8StringSink sink) {
            Utf8Sequence value = this.varcharFunc.getVarcharA(rec);
            int count = this.countFunc.getInt(rec);
            if (value != null && count != Integer.MIN_VALUE) {
                int len = Utf8s.validateUtf8(value);
                if (len == -1) {
                    return null;
                }
                int charHi = LeftVarcharFunctionFactory.getCharPos(len, count);
                sink.clear();
                Utf8s.strCpy(value, 0, charHi, sink);
                return sink;
            }
            return null;
        }
    }
}

