/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.math;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class AcosDoubleFunctionFactory
implements FunctionFactory {
    private static final String SYMBOL = "acos";

    @Override
    public String getSignature() {
        return "acos(D)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new AcosFunction(args.getQuick(0));
    }

    private static class AcosFunction
    extends DoubleFunction
    implements Function,
    UnaryFunction {
        final Function x;

        public AcosFunction(Function x) {
            this.x = x;
        }

        @Override
        public Function getArg() {
            return this.x;
        }

        @Override
        public double getDouble(Record rec) {
            return StrictMath.acos(this.x.getDouble(rec));
        }

        @Override
        public String getName() {
            return AcosDoubleFunctionFactory.SYMBOL;
        }
    }
}

