/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import org.jetbrains.annotations.NotNull;

public class FirstFloatGroupByFunction
extends FloatFunction
implements GroupByFunction,
UnaryFunction {
    protected final Function arg;
    protected int valueIndex;

    public FirstFloatGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putLong(this.valueIndex, rowId);
        mapValue.putFloat(this.valueIndex + 1, this.arg.getFloat(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public float getFloat(Record rec) {
        return rec.getFloat(this.valueIndex + 1);
    }

    @Override
    public String getName() {
        return "first";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(6);
        columnTypes.add(9);
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        long srcRowId = srcValue.getLong(this.valueIndex);
        long destRowId = destValue.getLong(this.valueIndex);
        if (srcRowId != Long.MIN_VALUE && (srcRowId < destRowId || destRowId == Long.MIN_VALUE)) {
            destValue.putLong(this.valueIndex, srcRowId);
            destValue.putFloat(this.valueIndex + 1, srcValue.getFloat(this.valueIndex + 1));
        }
    }

    @Override
    public void setFloat(MapValue mapValue, float value) {
        mapValue.putLong(this.valueIndex, Long.MIN_VALUE);
        mapValue.putFloat(this.valueIndex + 1, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        this.setFloat(mapValue, Float.NaN);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

