/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;

public class GeoByteConstant
extends GeoByteFunction
implements ConstantFunction {
    public static final GeoByteConstant NULL = new GeoByteConstant(-1, 14);
    private final byte hash;

    public GeoByteConstant(byte hash, int typep) {
        super(typep);
        this.hash = hash;
    }

    @Override
    public byte getGeoByte(Record rec) {
        return this.hash;
    }

    @Override
    public boolean isNullConstant() {
        return this.hash == -1;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.hash, ColumnType.getGeoHashBits(this.type));
    }
}

